/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.ExprUtil;
import org.reclipse.structure.generator.util.more.SDMUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.core.NamedElement;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.common.ArithmeticExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;
import org.storydriven.storydiagrams.patterns.expressions.PatternsExpressionsFactory;
import org.storydriven.storydiagrams.patterns.expressions.PrimitiveVariableExpression;

public class GetSizeOfNestedSetStep
implements Constants {
    private final IGenerator generator;
    private Map<PSNode, ObjectVariable> variables;
    private Counter counter;

    public GetSizeOfNestedSetStep(IGenerator generator) {
        this.generator = generator;
    }

    public void generate(Activity container, PSCombinedFragment outer, PSCombinedFragment inner, String paramName2, Map<PSNode, ObjectVariable> variables, Counter counter) {
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)container)});
        this.variables = variables;
        this.counter = counter;
        InitialNode initialNode = StorydrivenUtil.addInitialNode(container);
        StoryNode initializeSizeNode = this.addInitializeSizeNode(container);
        StorydrivenUtil.addTransition((ActivityNode)initialNode, (ActivityNode)initializeSizeNode);
        StoryNode iterateOverAnnotationSetActivity = this.addIterateOverAnnotationSetNode(container, paramName2);
        StorydrivenUtil.addTransition((ActivityNode)initializeSizeNode, (ActivityNode)iterateOverAnnotationSetActivity);
        StoryNode resetSizeNode = this.addResetSizeNode(container);
        StorydrivenUtil.addTransition((ActivityNode)iterateOverAnnotationSetActivity, (ActivityNode)resetSizeNode, EdgeGuard.EACH_TIME);
        StoryNode iterateOverInnerNode = this.addIterateOverInnerNode(container, outer, inner);
        StorydrivenUtil.addTransition((ActivityNode)resetSizeNode, (ActivityNode)iterateOverInnerNode);
        StoryNode iterateOverMatchedAnnotationsNode = this.addIterateOverMatchedAnnotationsNode(container, outer, inner, paramName2);
        StoryNode incrementCounterNode = this.addIncrementCounterNode(container);
        StorydrivenUtil.addTransition((ActivityNode)iterateOverMatchedAnnotationsNode, (ActivityNode)incrementCounterNode, EdgeGuard.EACH_TIME);
        StorydrivenUtil.addTransition((ActivityNode)incrementCounterNode, (ActivityNode)iterateOverMatchedAnnotationsNode);
        StorydrivenUtil.addTransition((ActivityNode)iterateOverInnerNode, (ActivityNode)iterateOverMatchedAnnotationsNode);
        StoryNode checkSizeNode = this.addCheckSizeNode(container, inner);
        StorydrivenUtil.addTransition((ActivityNode)iterateOverMatchedAnnotationsNode, (ActivityNode)checkSizeNode, EdgeGuard.END);
        ActivityFinalNode sizeCheckFailedFinalNode = StorydrivenUtil.addFailureFinalNode(container);
        StorydrivenUtil.addTransition((ActivityNode)checkSizeNode, (ActivityNode)iterateOverAnnotationSetActivity, EdgeGuard.SUCCESS);
        StorydrivenUtil.addTransition((ActivityNode)checkSizeNode, (ActivityNode)sizeCheckFailedFinalNode, EdgeGuard.FAILURE);
        ActivityFinalNode sizeCheckSucceededFinalNode = StorydrivenUtil.addSuccessFinalNode(container);
        StorydrivenUtil.addTransition((ActivityNode)iterateOverAnnotationSetActivity, (ActivityNode)sizeCheckSucceededFinalNode, EdgeGuard.END);
    }

    private StoryNode addInitializeSizeNode(Activity container) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Initialize size variable");
        StoryPattern storyPattern = element.getStoryPattern();
        PrimitiveVariable size = SDMUtil.createPrimitiveObject(EcorePackage.eINSTANCE.getEDouble(), "size", false, storyPattern);
        LiteralExpression expr = ExprUtil.eInt(0);
        size.setBindingExpression((Expression)expr);
        return element;
    }

    private StoryNode addIterateOverAnnotationSetNode(Activity container, String setName) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Match annotation");
        element.setForEach(true);
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable resultSet = StorydrivenUtil.addObjectVariable(element, setName, classifier);
        resultSet.setBindingState(BindingState.BOUND);
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable annotation = StorydrivenUtil.addObjectVariable(element, "annotation", classifier);
        EReference type = AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS;
        StorydrivenUtil.addLinkVariable(element, resultSet, annotation, type);
        return element;
    }

    private StoryNode addResetSizeNode(Activity container) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Create size variable");
        StoryPattern storyPattern = element.getStoryPattern();
        PrimitiveVariable size = SDMUtil.createPrimitiveObject(EcorePackage.eINSTANCE.getEDouble(), "size", false, storyPattern);
        PrimitiveVariableExpression varExpression = PatternsExpressionsFactory.eINSTANCE.createPrimitiveVariableExpression();
        varExpression.setPrimitiveVariable(size);
        size.setBindingExpression((Expression)ExprUtil.eDouble(0.0));
        return element;
    }

    private StoryNode addIterateOverInnerNode(Activity container, PSCombinedFragment parent, PSCombinedFragment child) {
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(container, "Match bound objects");
        EClass classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable annotation = StorydrivenUtil.addObjectVariable(storyActivity, "annotation", classifier);
        annotation.setBindingState(BindingState.BOUND);
        this.linkOuterBoundObjects(storyActivity.getStoryPattern(), annotation, parent, child, false);
        return storyActivity;
    }

    private StoryNode addIterateOverMatchedAnnotationsNode(Activity container, PSCombinedFragment parentFragment, PSCombinedFragment childFragment, String setName) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Iterate over annotations that contain the bound objects");
        element.setForEach(true);
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable resultSet = StorydrivenUtil.addObjectVariable(element, setName, classifier);
        resultSet.setBindingState(BindingState.BOUND);
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable annotation = StorydrivenUtil.addObjectVariable(element, "annotation2", classifier);
        StoryPattern storyPattern = element.getStoryPattern();
        this.linkBoundObjects(storyPattern, annotation, childFragment, false);
        this.linkOuterBoundObjects(storyPattern, annotation, parentFragment, childFragment, true);
        SDMUtil.createSetInstanceAnnotationResultSetLink(resultSet, annotation, false, storyPattern);
        return element;
    }

    private void linkOuterBoundObjects(StoryPattern container, ObjectVariable element, PSCombinedFragment outer, PSCombinedFragment inner, boolean bound) {
        for (PSCombinedFragmentItem item : outer.getChildren()) {
            if (!(item instanceof PSNode)) continue;
            PSNode psNode = (PSNode)item;
            if (inner.getChildren().contains((Object)psNode)) continue;
            this.addNode(container, element, bound, psNode);
        }
        this.addConnections(container, outer, inner);
    }

    private void linkBoundObjects(StoryPattern container, ObjectVariable element, PSCombinedFragment fragment, boolean bound) {
        for (PSCombinedFragmentItem item : fragment.getChildren()) {
            if (!(item instanceof PSNode)) continue;
            PSNode psNode = (PSNode)item;
            this.addNode(container, element, bound, psNode);
        }
        this.addConnections(container, fragment, null);
    }

    private void addNode(StoryPattern container, ObjectVariable element, boolean bound, PSNode psNode) {
        if (psNode.getModifier() != ModifierType.NEGATIVE) {
            if (psNode.getName() == null || psNode.getName().equals("")) {
                throw new IllegalStateException("PSNode object \"" + psNode + "\" has no name.");
            }
            ObjectVariable boundObject = null;
            if (psNode instanceof PSObject) {
                boundObject = SDMUtil.createObject((PSObject)psNode, bound, true, container, this.variables, this.counter);
            } else if (psNode instanceof PSAnnotation && !ModelHelper.isCreate((PSAnnotation)((PSAnnotation)psNode))) {
                this.generator.getAnnotationClass(((PSAnnotation)psNode).getType());
                EClass annoType = this.generator.getAnnotationClass(((PSAnnotation)psNode).getType());
                boundObject = SDMUtil.createAnnotationObject((PSAnnotation)psNode, annoType, bound, false, container, this.variables, this.counter);
            }
            if (psNode.getModifier() == ModifierType.ADDITIONAL && boundObject != null) {
                boundObject.setBindingSemantics(BindingSemantics.MANDATORY);
            }
            if (boundObject != null) {
                SDMUtil.createBoundObjectsLink(element, boundObject, psNode, false, container);
            }
        }
    }

    private void addConnections(StoryPattern container, PSCombinedFragment outer, PSCombinedFragment inner) {
        for (PSCombinedFragmentItem combinedFragmentItem : outer.getChildren()) {
            PSNode node = null;
            if (!(combinedFragmentItem instanceof PSNode)) continue;
            node = (PSNode)combinedFragmentItem;
            for (PSConnection connection : node.getOutgoing()) {
                PSNode targetNode = connection.getTarget();
                if (!ModelHelper.nodeIsInSet((PSNode)targetNode, (PSCombinedFragment)outer) || inner != null && (ModelHelper.nodeIsInSet((PSNode)targetNode, (PSCombinedFragment)inner) || ModelHelper.nodeIsInSet((PSNode)node, (PSCombinedFragment)inner))) continue;
                ObjectVariable source = this.variables.get(connection.getSource());
                ObjectVariable target = this.variables.get(connection.getTarget());
                if (connection instanceof PSLink) {
                    PSLink link = (PSLink)connection;
                    SDMUtil.createLink(source, target, link.getInstanceOf(), link.getQualifier(), false, BindingSemantics.MANDATORY, container);
                    continue;
                }
                if (!(connection instanceof PSPath)) continue;
                SDMUtil.createPath((PSPath)connection, source, target, container);
            }
        }
    }

    private StoryNode addIncrementCounterNode(Activity container) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Increment SIZE variable");
        StoryPattern storyPattern = element.getStoryPattern();
        PrimitiveVariable size = SDMUtil.createPrimitiveObject(EcorePackage.eINSTANCE.getEInt(), "size", false, storyPattern);
        PrimitiveVariableExpression varExpression = PatternsExpressionsFactory.eINSTANCE.createPrimitiveVariableExpression();
        varExpression.setPrimitiveVariable(size);
        ArithmeticExpression incrementation = ExprUtil.plus((Expression)varExpression, (Expression)ExprUtil.eInt(1));
        size.setBindingExpression((Expression)incrementation);
        return element;
    }

    private StoryNode addCheckSizeNode(Activity container, PSCombinedFragment set) {
        StoryNode element = StorydrivenUtil.addStoryNode(container, "Check size expression of nested set for current set instance.");
        StoryPattern storyPattern = element.getStoryPattern();
        PSNodeConstraint nodeConstraint = set.getConstraint();
        if (nodeConstraint instanceof PSMetricConstraint && "SIZE".equals(((PSMetricConstraint)nodeConstraint).getMetricAcronym())) {
            PSMetricConstraint metricConstraint = (PSMetricConstraint)nodeConstraint;
            StringBuffer expression = new StringBuffer();
            expression.append("size" + ModelHelper.getReadable((OperatorType)metricConstraint.getOperator()) + " " + metricConstraint.getValueExpression());
            SDMUtil.createConstraint(expression.toString(), storyPattern);
        }
        return element;
    }
}

