/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EParameter;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.SDMUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.PSSpecificationConstraint;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.core.NamedElement;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class FindSetSubGraphStep
implements Constants {
    private final IGenerator generator;
    private Map<PSNode, ObjectVariable> variables;
    private Activity container;
    private PSCombinedFragment fragment;
    private PSNode trigger;
    private Counter counter;

    public FindSetSubGraphStep(IGenerator generator) {
        this.generator = generator;
        this.variables = new HashMap<PSNode, ObjectVariable>();
    }

    public void generate(Activity container, PSCombinedFragment fragment, PSNode trigger, Counter counter) {
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)container)});
        this.container = container;
        this.fragment = fragment;
        this.trigger = trigger;
        this.counter = counter;
        InitialNode initialNode = StorydrivenUtil.addInitialNode(container);
        StoryNode checkPatternNode = this.addCheckPatternNode();
        StorydrivenUtil.addTransition((ActivityNode)initialNode, (ActivityNode)checkPatternNode);
        ActivityNode createInstanceNode = this.addCreateInstanceAnnotationNode();
        StorydrivenUtil.addTransition((ActivityNode)checkPatternNode, createInstanceNode, EdgeGuard.EACH_TIME);
        StorydrivenUtil.addTransition(createInstanceNode, (ActivityNode)checkPatternNode);
        ActivityFinalNode finalNode = StorydrivenUtil.addActivityFinalNode(container, "annotationSet");
        StorydrivenUtil.addTransition((ActivityNode)checkPatternNode, (ActivityNode)finalNode, EdgeGuard.END);
        this.variables.clear();
    }

    private StoryNode addCheckPatternNode() {
        PSNode node;
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.container, "Apply graph grammar rule for the subgraph in the set fragment.");
        storyActivity.setForEach(true);
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        this.variables.clear();
        for (PSCombinedFragmentItem item : this.fragment.getChildren()) {
            if (item instanceof PSNode) {
                node = (PSNode)item;
                SDMUtil.addNodeToStoryPattern(storyPattern, node, this.variables, this.counter, this.generator);
                continue;
            }
            if (!(item instanceof PSSpecificationConstraint) || ModelHelper.isSearchForThisOptional((PSSpecificationConstraint)((PSSpecificationConstraint)item))) continue;
            SDMUtil.createConstraint(((PSSpecificationConstraint)item).getExpression(), storyPattern);
        }
        for (PSCombinedFragmentItem combinedFragmentItem : this.fragment.getChildren()) {
            PSLink link;
            ObjectVariable target;
            ObjectVariable source;
            node = null;
            if (!(combinedFragmentItem instanceof PSNode)) continue;
            node = (PSNode)combinedFragmentItem;
            for (PSConnection connection : node.getOutgoing()) {
                PSNode targetNode = connection.getTarget();
                if (!ModelHelper.nodeIsInSet((PSNode)targetNode, (PSCombinedFragment)this.fragment) && !ModelHelper.nodeIsInNoSet((PSNode)targetNode)) continue;
                if (ModelHelper.nodeIsInNoSet((PSNode)targetNode) && this.variables.get(targetNode) == null) {
                    SDMUtil.addNodeToStoryPattern(storyPattern, targetNode, this.variables, this.counter, this.generator);
                }
                source = this.variables.get(connection.getSource());
                target = this.variables.get(connection.getTarget());
                if (connection instanceof PSLink) {
                    link = (PSLink)connection;
                    SDMUtil.createLink(source, target, link.getInstanceOf(), link.getQualifier(), false, BindingSemantics.MANDATORY, storyPattern);
                    continue;
                }
                if (!(connection instanceof PSPath)) continue;
                SDMUtil.createPath((PSPath)connection, source, target, storyPattern);
            }
            for (PSConnection connection : node.getIncoming()) {
                PSNode sourceNode = connection.getSource();
                if (sourceNode instanceof PSAnnotation && ModelHelper.isCreate((PSAnnotation)((PSAnnotation)sourceNode)) || !ModelHelper.nodeIsInNoSet((PSNode)sourceNode)) continue;
                if (this.variables.get(sourceNode) == null) {
                    SDMUtil.addNodeToStoryPattern(storyPattern, sourceNode, this.variables, this.counter, this.generator);
                }
                source = this.variables.get(connection.getSource());
                target = this.variables.get(connection.getTarget());
                if (connection instanceof PSLink) {
                    link = (PSLink)connection;
                    SDMUtil.createLink(source, target, link.getInstanceOf(), link.getQualifier(), false, BindingSemantics.MANDATORY, storyPattern);
                    continue;
                }
                if (!(connection instanceof PSPath)) continue;
                SDMUtil.createPath((PSPath)connection, source, target, storyPattern);
            }
        }
        ObjectVariable triggerObject = (ObjectVariable)SDMUtil.findVariableByName(storyPattern, this.trigger.getName());
        if (triggerObject == null) {
            triggerObject = SDMUtil.createObject(this.trigger, true, false, storyPattern, this.variables, this.counter, this.generator);
        }
        SDMUtil.configureTrigger(triggerObject, this.trigger, storyPattern);
        Expression expr = ExpressionsUtil.createParameterExpression(StorydrivenUtil.getEParameter(this.container, "element"));
        triggerObject.setBindingExpression(expr);
        for (PSConnection con : this.trigger.getOutgoing()) {
            PSNode target = con.getTarget();
            if (!this.fragment.getChildren().contains((Object)target)) continue;
            boolean done = false;
            for (AbstractVariable var : storyPattern.getVariables()) {
                if (!var.getName().equals(target.getName())) continue;
                SDMUtil.createLink(triggerObject, (ObjectVariable)var, ((PSLink)con).getInstanceOf(), ((PSLink)con).getQualifier(), false, BindingSemantics.MANDATORY, storyPattern);
                done = true;
            }
            if (done) break;
        }
        return storyActivity;
    }

    private ActivityNode addCreateInstanceAnnotationNode() {
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.container, "Create a new annotation for the matched pattern");
        EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable annotationResultSet = StorydrivenUtil.addObjectVariable(storyActivity, "annotationSet", classifier);
        annotationResultSet.setBindingState(BindingState.BOUND);
        EParameter param = StorydrivenUtil.getEParameter(this.container, "annotationSet");
        Expression annoationSetParam = ExpressionsUtil.createParameterExpression(param);
        annotationResultSet.setBindingExpression(annoationSetParam);
        classifier = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        ObjectVariable setInstanceVariable = StorydrivenUtil.addObjectVariable(storyActivity, "setAnnotation", classifier);
        setInstanceVariable.setBindingOperator(BindingOperator.CREATE);
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        for (PSCombinedFragmentItem item : this.fragment.getChildren()) {
            PSSpecificationConstraint constraint;
            if (!(item instanceof PSSpecificationConstraint) || !(constraint = (PSSpecificationConstraint)item).getExpression().toLowerCase().startsWith("maybe")) continue;
            SDMUtil.createConstraint(constraint.getExpression(), storyPattern);
        }
        this.linkBoundObjects(storyActivity, setInstanceVariable);
        SDMUtil.createLink(annotationResultSet, setInstanceVariable, AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS, null, true, BindingSemantics.MANDATORY, storyPattern);
        return storyActivity;
    }

    private void linkBoundObjects(StoryNode storyNode, ObjectVariable setAnnotationVariable) {
        for (PSCombinedFragmentItem item : this.fragment.getChildren()) {
            PSNode psNode;
            if (!(item instanceof PSNode) || ModifierType.NEGATIVE.equals((Object)(psNode = (PSNode)item).getModifier())) continue;
            ObjectVariable boundObject = null;
            if (psNode instanceof PSObject) {
                boundObject = SDMUtil.createObject((PSObject)psNode, true, true, storyNode.getStoryPattern(), this.variables, this.counter);
            } else if (psNode instanceof PSAnnotation && !ModelHelper.isCreate((PSAnnotation)((PSAnnotation)psNode))) {
                EClass annoType = this.generator.getAnnotationClass(((PSAnnotation)psNode).getType());
                boundObject = SDMUtil.createAnnotationObject((PSAnnotation)psNode, annoType, true, false, storyNode.getStoryPattern(), this.variables, this.counter);
            }
            if (ModifierType.ADDITIONAL.equals((Object)psNode.getModifier()) && boundObject != null) {
                boundObject.setBindingSemantics(BindingSemantics.MANDATORY);
            }
            if (boundObject == null) continue;
            SDMUtil.createBoundObjectsLink(setAnnotationVariable, boundObject, psNode, true, storyNode.getStoryPattern());
        }
    }
}

