/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.reclipse.structure.generator.steps.FindSetSubGraphStep;
import org.reclipse.structure.generator.steps.GetSizeOfNestedSetStep;
import org.reclipse.structure.generator.steps.MatchPairsStep;
import org.reclipse.structure.generator.steps.RemoveInstancesStep;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.EcoreUtil;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.SDMUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.core.NamedElement;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.ExpressionsFactory;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.calls.Invocation;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.Constraint;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PatternsFactory;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class FindSetFragmentsStep
implements Constants {
    private final IGenerator generator;
    private final FindSetSubGraphStep findSubGraphMethodGenerator;
    private PSPatternSpecification pattern;
    private Map<PSNode, ObjectVariable> storyItems;
    private Counter counter;
    private Collection<String> annotationSets;
    private Activity activity;
    private EOperation findSetFragmentMethod;
    private Map<String, PSCombinedFragment> setFragments;

    public FindSetFragmentsStep(IGenerator generator) {
        this.generator = generator;
        this.findSubGraphMethodGenerator = new FindSetSubGraphStep(generator);
    }

    public void generate(Activity activity, PSPatternSpecification pattern) {
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)activity)});
        this.pattern = pattern;
        this.storyItems = new HashMap<PSNode, ObjectVariable>();
        this.counter = new Counter();
        this.annotationSets = new ArrayList<String>();
        this.activity = activity;
        this.findSetFragmentMethod = activity.getOwningOperation().getOperation();
        InitialNode initialNode = StorydrivenUtil.addInitialNode(activity);
        ActivityNode initializeSetsNode = this.addInitializeSetsNode();
        StorydrivenUtil.addTransition((ActivityNode)initialNode, initializeSetsNode);
        ActivityNode lastNode = initializeSetsNode;
        HashSet<PSCombinedFragment> boundSets = new HashSet<PSCombinedFragment>();
        for (String setName : this.setFragments.keySet()) {
            ActivityNode bindSetNode;
            PSCombinedFragment set = this.setFragments.get(setName);
            PSNode connectedElement = ModelHelper.getConnectedElementInNoFragment((PSCombinedFragment)set);
            if (connectedElement == null) continue;
            lastNode = bindSetNode = this.addBindSetNode(setName, set, connectedElement, lastNode);
            boundSets.add(set);
            Collection<PSCombinedFragment> overlappingSets = this.getOverlappingSetFragments(set);
            for (PSCombinedFragment overlappingSet : overlappingSets) {
                ActivityNode removeWrongInstancesNode;
                if (!boundSets.contains(overlappingSet)) continue;
                ActivityNode matchPairsNode = this.addMatchPairsNode(set, overlappingSet, lastNode);
                lastNode = removeWrongInstancesNode = this.addRemoveWrongInstancesNode(set, overlappingSet, matchPairsNode);
            }
        }
        ActivityNode checkSetSizeNode = this.addCheckSetSizeNode();
        StorydrivenUtil.addTransition(lastNode, checkSetSizeNode);
        ActivityNode removeSetsNode = this.addRemoveSetsNode();
        StorydrivenUtil.addTransition(checkSetSizeNode, removeSetsNode, EdgeGuard.FAILURE);
        ActivityNode createResultNode = this.createCreateResultActivity();
        StorydrivenUtil.addTransition(checkSetSizeNode, createResultNode, EdgeGuard.SUCCESS);
        ActivityFinalNode failureFinalNode = StorydrivenUtil.addFailureFinalNode(activity);
        StorydrivenUtil.addTransition(removeSetsNode, (ActivityNode)failureFinalNode);
        ActivityNode bindElementsNode = this.createBindElements(createResultNode);
        ActivityFinalNode successFinalNode = StorydrivenUtil.addSuccessFinalNode(activity);
        StorydrivenUtil.addTransition(bindElementsNode, (ActivityNode)successFinalNode, EdgeGuard.END);
    }

    private ActivityNode createBindElements(ActivityNode sourceNode) {
        StoryNode lastNode = null;
        for (String key : this.setFragments.keySet()) {
            StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Find Bounded Elements From '%1s'", key);
            storyNode.setForEach(true);
            PSCombinedFragment fragment = this.setFragments.get(key);
            String name = "annotationSet_" + key;
            EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
            ObjectVariable setAnnotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            setAnnotationVar.setBindingState(BindingState.BOUND);
            name = StorydrivenUtil.getValidName(this.pattern, "annotation" + key);
            classifier = AnnotationsPackage.Literals.ASG_ANNOTATION;
            ObjectVariable setInstanceAnnotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            EReference type = AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS;
            StorydrivenUtil.addLinkVariable(storyNode, setAnnotationVar, setInstanceAnnotationVar, type);
            for (PSCombinedFragmentItem item : fragment.getChildren()) {
                if (!(item instanceof PSNode) || ModifierType.ADDITIONAL.equals((Object)((PSNode)item).getModifier())) continue;
                name = item.getName();
                classifier = EcorePackage.Literals.EOBJECT;
                ObjectVariable variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
                type = AnnotationsPackage.Literals.ASG_ANNOTATION__BOUND_OBJECTS;
                LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(storyNode, setInstanceAnnotationVar, variable, type);
                linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(name));
            }
            StoryNode bindNode = StorydrivenUtil.addStoryNode(this.activity, "Bind The Elements");
            StorydrivenUtil.addTransition((ActivityNode)storyNode, (ActivityNode)bindNode, EdgeGuard.EACH_TIME);
            StorydrivenUtil.addTransition((ActivityNode)bindNode, (ActivityNode)storyNode);
            name = StorydrivenUtil.getValidName(this.pattern, "annotation");
            classifier = AnnotationsPackage.Literals.ASG_ANNOTATION;
            ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(bindNode, name, classifier);
            annotationVar.setBindingState(BindingState.BOUND);
            for (PSCombinedFragmentItem item : fragment.getChildren()) {
                if (!(item instanceof PSNode) || ModifierType.ADDITIONAL.equals((Object)((PSNode)item).getModifier())) continue;
                name = item.getName();
                classifier = EcorePackage.Literals.EOBJECT;
                ObjectVariable variable = StorydrivenUtil.addObjectVariable(bindNode, name, classifier);
                variable.setBindingState(BindingState.BOUND);
                LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(bindNode, annotationVar, variable, type);
                linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(name));
                linkVariable.setBindingOperator(BindingOperator.CREATE);
                classifier = EcorePackage.Literals.EOBJECT;
            }
            if (lastNode == null) {
                StorydrivenUtil.addTransition(sourceNode, (ActivityNode)storyNode);
            } else {
                StorydrivenUtil.addTransition(lastNode, (ActivityNode)storyNode, EdgeGuard.END);
            }
            lastNode = storyNode;
        }
        return lastNode;
    }

    private ActivityNode addInitializeSetsNode() {
        StoryNode element = StorydrivenUtil.addStoryNode(this.activity, "Create empty set containers");
        this.setFragments = StorydrivenUtil.getSetFragmentsMap(this.pattern);
        for (String setName : this.setFragments.keySet()) {
            this.createAnnotationResultSetObject(element.getStoryPattern(), false, true, setName);
        }
        return element;
    }

    private ActivityNode addMatchPairsNode(PSCombinedFragment set1, PSCombinedFragment set2, ActivityNode lastActivity) {
        String setName1 = this.getNameForSet(set1);
        String setName2 = this.getNameForSet(set2);
        String methodName = "matchPairs_" + setName1 + "_" + setName2;
        String paramName1 = "annotationSet_" + setName1;
        String paramName2 = "annotationSet_" + setName2;
        String resultSuffix = String.valueOf(setName1) + "_" + setName2;
        EClass engineClass = this.generator.getEngineClass(this.pattern);
        EClass resultType = AnnotationsPackage.Literals.ANNOTATION_SET;
        EOperation method = EcoreUtil.addEOperation(engineClass, methodName);
        method.setEType((EClassifier)resultType);
        EcoreUtil.addEParameter(method, paramName1, (EClassifier)resultType);
        EcoreUtil.addEParameter(method, paramName2, (EClassifier)resultType);
        EcoreUtil.addEParameter(method, "this", (EClassifier)engineClass);
        Activity MPMactivity = this.generator.createActivity(method, this.pattern);
        MatchPairsStep matchPairsMethodGenerator = new MatchPairsStep(this.generator);
        matchPairsMethodGenerator.generate(MPMactivity, this.pattern, set1, paramName1, set2, paramName2, this.counter, this.storyItems);
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.activity, "Match pairs");
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        SDMUtil.createTransitionNoneGuarded(lastActivity, (ActivityNode)storyActivity, this.activity);
        ObjectVariable resultObject = this.createAnnotationResultSetObject(storyPattern, false, true, resultSuffix);
        ObjectVariable set1Obj = SDMUtil.createObject(AnnotationsPackage.eINSTANCE.getAnnotationSet(), paramName1, true, false, storyPattern);
        ObjectVariable set2Obj = SDMUtil.createObject(AnnotationsPackage.eINSTANCE.getAnnotationSet(), paramName2, true, false, storyPattern);
        ActivityCallNode call = SDMUtil.createActivityCallNode(this.activity, MPMactivity);
        call.setName("Match pairs");
        for (EParameter eParameter : MPMactivity.getOwningOperation().getOperation().getEParameters()) {
            if (paramName1.equals(eParameter.getName())) {
                SDMUtil.createParameterBinding(eParameter, set1Obj, (Invocation)call);
                continue;
            }
            if (paramName2.equals(eParameter.getName())) {
                SDMUtil.createParameterBinding(eParameter, set2Obj, (Invocation)call);
                continue;
            }
            if (!"this".equals(eParameter.getName())) continue;
            EParameter forwarded = EcoreUtil.getEParameter(this.findSetFragmentMethod, "this");
            StorydrivenUtil.createParameterBindingForwarding(eParameter, forwarded, (Invocation)call);
        }
        for (EParameter outParam : MPMactivity.getOutParameters()) {
            SDMUtil.createParameterBinding(outParam, resultObject, (Invocation)call);
        }
        this.annotationSets.add(resultSuffix);
        SDMUtil.createTransitionNoneGuarded((ActivityNode)storyActivity, (ActivityNode)call, this.activity);
        return call;
    }

    private ActivityNode addRemoveWrongInstancesNode(PSCombinedFragment set1, PSCombinedFragment set2, ActivityNode lastNode) {
        String setName1 = this.getNameForSet(set1);
        String setName2 = this.getNameForSet(set2);
        String paramName1 = "annotationSet_" + setName1;
        String paramName2 = "annotationSet_" + setName2;
        String resultSuffix = String.valueOf(setName1) + "_" + setName2;
        String paramName3 = "annotationSet_" + resultSuffix;
        String methodName1 = "removeInstances_" + setName1;
        String methodName2 = "removeInstances_" + setName2;
        EClass engineClass = this.generator.getEngineClass(this.pattern);
        EClass resultType = AnnotationsPackage.Literals.SET_INSTANCE_ANNOTATION;
        EOperation method1 = EcoreUtil.addEOperation(engineClass, methodName1);
        method1.setEType((EClassifier)resultType);
        EcoreUtil.addEParameter(method1, paramName1, (EClassifier)resultType);
        EcoreUtil.addEParameter(method1, paramName3, (EClassifier)resultType);
        EcoreUtil.addEParameter(method1, "this", (EClassifier)engineClass);
        Activity activity1 = this.generator.createActivity(method1, this.pattern);
        RemoveInstancesStep removeInstancesGenerator1 = new RemoveInstancesStep(this.generator);
        removeInstancesGenerator1.generate(activity1, this.pattern, paramName1, paramName3);
        EOperation method2 = EcoreUtil.addEOperation(engineClass, methodName2);
        method2.setEType((EClassifier)resultType);
        EcoreUtil.addEParameter(method2, paramName2, (EClassifier)resultType);
        EcoreUtil.addEParameter(method2, paramName3, (EClassifier)resultType);
        EcoreUtil.addEParameter(method2, "this", (EClassifier)engineClass);
        Activity activity2 = this.generator.createActivity(method2, this.pattern);
        RemoveInstancesStep removeInstancesGenerator2 = new RemoveInstancesStep(this.generator);
        removeInstancesGenerator2.generate(activity2, this.pattern, paramName2, paramName3);
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.activity, "Remove wrong set instances from '%1s' and '%2s'", paramName1, paramName2);
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        SDMUtil.createTransitionNoneGuarded(lastNode, (ActivityNode)storyActivity, this.activity);
        ObjectVariable set1Obj = this.createAnnotationResultSetObject(storyPattern, true, false, setName1);
        ObjectVariable set2Obj = this.createAnnotationResultSetObject(storyPattern, true, false, setName2);
        ObjectVariable resultObj = this.createAnnotationResultSetObject(storyPattern, true, false, resultSuffix);
        ActivityCallNode call1 = SDMUtil.createActivityCallNode(this.activity, activity1);
        for (EParameter eParameter : method1.getEParameters()) {
            if (paramName1.equals(eParameter.getName())) {
                SDMUtil.createParameterBinding(eParameter, set1Obj, (Invocation)call1);
                continue;
            }
            if (paramName3.equals(eParameter.getName())) {
                SDMUtil.createParameterBinding(eParameter, resultObj, (Invocation)call1);
                continue;
            }
            if (!"this".equals(eParameter.getName())) continue;
            EParameter forwarded = EcoreUtil.getEParameter(this.findSetFragmentMethod, "this");
            StorydrivenUtil.createParameterBindingForwarding(eParameter, forwarded, (Invocation)call1);
        }
        for (EParameter outParam : activity1.getOwningOperation().getOutParameters()) {
            SDMUtil.createParameterBinding(outParam, set1Obj, (Invocation)call1);
        }
        SDMUtil.createTransitionNoneGuarded((ActivityNode)storyActivity, (ActivityNode)call1, this.activity);
        ActivityCallNode call2 = SDMUtil.createActivityCallNode(this.activity, activity2);
        for (EParameter eParameter : method2.getEParameters()) {
            if (paramName2.equals(eParameter.getName())) {
                SDMUtil.createParameterBinding(eParameter, set2Obj, (Invocation)call2);
                continue;
            }
            if (paramName3.equals(eParameter.getName())) {
                SDMUtil.createParameterBinding(eParameter, resultObj, (Invocation)call2);
                continue;
            }
            if (!"this".equals(eParameter.getName())) continue;
            EParameter forwarded = EcoreUtil.getEParameter(this.findSetFragmentMethod, "this");
            StorydrivenUtil.createParameterBindingForwarding(eParameter, forwarded, (Invocation)call2);
        }
        if (activity2.getOwningOperation().getOutParameters() != null && !activity2.getOwningOperation().getOutParameters().isEmpty()) {
            EParameter call2Result = (EParameter)activity2.getOwningOperation().getOutParameters().get(0);
            SDMUtil.createParameterBinding(call2Result, set2Obj, (Invocation)call2);
        }
        SDMUtil.createTransitionNoneGuarded((ActivityNode)call1, (ActivityNode)call2, this.activity);
        return call2;
    }

    private ObjectVariable createAnnotationResultSetObject(StoryPattern pattern, boolean bound, boolean create, String setName) {
        ObjectVariable setObject = PatternsFactory.eINSTANCE.createObjectVariable();
        setObject.setClassifier(AnnotationsPackage.Literals.ANNOTATION_SET);
        setObject.setName("annotationSet_" + setName);
        if (bound) {
            setObject.setBindingState(BindingState.BOUND);
        }
        if (create) {
            setObject.setBindingOperator(BindingOperator.CREATE);
        }
        pattern.getVariables().add((Object)setObject);
        return setObject;
    }

    private ActivityNode addBindSetNode(String setName, PSCombinedFragment fragment, PSNode connectedElement, ActivityNode lastActivity) {
        String elementName = "elementConnectedTo" + setName;
        Activity findSubGraphActivity = this.generator.createActivity(this.createFindSubGraphMethod(setName), this.pattern);
        this.findSubGraphMethodGenerator.generate(findSubGraphActivity, fragment, connectedElement, this.counter);
        StoryNode bindSetNode = StorydrivenUtil.addStoryNode(this.activity, "Bind '%1s'", setName);
        StoryPattern storyPattern = bindSetNode.getStoryPattern();
        StorydrivenUtil.addTransition(lastActivity, (ActivityNode)bindSetNode);
        ObjectVariable annotationObject = SDMUtil.createTemporaryAnnotationObject(storyPattern, true, false);
        EParameter tempAnnoParam = StorydrivenUtil.getEParameter(this.activity, "annotation");
        annotationObject.setBindingExpression(ExpressionsUtil.createParameterExpression(tempAnnoParam));
        ObjectVariable element = null;
        if (connectedElement instanceof PSAnnotation) {
            PSAnnotation anno = (PSAnnotation)connectedElement;
            EClass annoType = this.generator.getAnnotationClass(anno.getType());
            element = SDMUtil.createAnnotationObject(anno, annoType, false, false, storyPattern, this.storyItems, this.counter);
        } else {
            element = SDMUtil.createObject((PSObject)connectedElement, false, false, storyPattern, this.storyItems, this.counter);
        }
        element.setName(elementName);
        SDMUtil.createBoundObjectsLink(annotationObject, element, connectedElement, false, storyPattern);
        String paramName1 = "annotationSet_" + setName;
        ActivityCallNode call = SDMUtil.createActivityCallNode(this.activity, findSubGraphActivity);
        ObjectVariable annotationsSetObject = SDMUtil.createObject(SDMUtil.getAnnotationSetClass(), paramName1, true, false, storyPattern);
        EParameter callParameter = StorydrivenUtil.getEParameter(findSubGraphActivity, "this");
        EParameter operationParameter = StorydrivenUtil.getEParameter(this.activity, "this");
        StorydrivenUtil.createParameterBindingForwarding(callParameter, operationParameter, (Invocation)call);
        callParameter = StorydrivenUtil.getEParameter(findSubGraphActivity, "annotation");
        operationParameter = StorydrivenUtil.getEParameter(this.activity, "annotation");
        StorydrivenUtil.createParameterBindingForwarding(callParameter, operationParameter, (Invocation)call);
        operationParameter = StorydrivenUtil.getEParameter(findSubGraphActivity, "element");
        SDMUtil.createParameterBinding(operationParameter, element, (Invocation)call);
        operationParameter = StorydrivenUtil.getEParameter(findSubGraphActivity, "annotationSet");
        SDMUtil.createParameterBinding(operationParameter, annotationsSetObject, (Invocation)call);
        for (EParameter outParam : findSubGraphActivity.getOwningOperation().getOutParameters()) {
            SDMUtil.createParameterBinding(outParam, annotationsSetObject, (Invocation)call);
        }
        this.annotationSets.add(setName);
        SDMUtil.createTransitionNoneGuarded((ActivityNode)bindSetNode, (ActivityNode)call, this.activity);
        return call;
    }

    private EOperation createFindSubGraphMethod(String name) {
        EOperation findSubGraphMethod = EcoreUtil.addEOperation(this.generator.getEngineClass(this.pattern), "findSubGraphIn" + name);
        findSubGraphMethod.setEType((EClassifier)AnnotationsPackage.Literals.ANNOTATION_SET);
        EcoreUtil.addEParameter(findSubGraphMethod, "this", (EClassifier)this.generator.getEngineClass(this.pattern));
        EcoreUtil.addEParameter(findSubGraphMethod, "annotation", (EClassifier)AnnotationsPackage.Literals.ASG_ANNOTATION);
        EcoreUtil.addEParameter(findSubGraphMethod, "annotationSet", (EClassifier)AnnotationsPackage.Literals.ANNOTATION_SET);
        EcoreUtil.addEParameter(findSubGraphMethod, "element", (EClassifier)EcorePackage.Literals.EOBJECT);
        return findSubGraphMethod;
    }

    private Collection<PSCombinedFragment> getOverlappingSetFragments(PSCombinedFragment fragment) {
        ArrayList<PSCombinedFragment> overlappingSets = new ArrayList<PSCombinedFragment>();
        for (PSCombinedFragment setFragment : this.setFragments.values()) {
            if (!ModelHelper.overlaps((PSCombinedFragment)fragment, (PSCombinedFragment)setFragment)) continue;
            overlappingSets.add(setFragment);
        }
        return overlappingSets;
    }

    private static Constraint createSetConstraint(PSMetricConstraint nodeConstraint, ObjectVariable theSet) {
        StringBuilder text = new StringBuilder();
        text.append("self.annotations->size()");
        switch (nodeConstraint.getOperator()) {
            case EQUAL: {
                text.append("=");
                break;
            }
            case GREATER: {
                text.append(">");
                break;
            }
            case GREATER_OR_EQUAL: {
                text.append(">=");
                break;
            }
            case LESS: {
                text.append("<");
                break;
            }
            case LESS_OR_EQUAL: {
                text.append("<=");
                break;
            }
            case UNEQUAL: {
                text.append("<>");
                break;
            }
            default: {
                text.append("!REG!");
            }
        }
        text.append(nodeConstraint.getValueExpression());
        TextualExpression exp = ExpressionsFactory.eINSTANCE.createTextualExpression();
        exp.setExpressionText(text.toString());
        exp.setLanguage("OCL");
        Constraint cons = PatternsFactory.eINSTANCE.createConstraint();
        cons.setConstraintExpression((Expression)exp);
        cons.setObjectVariable((AbstractVariable)theSet);
        return cons;
    }

    private ActivityNode addCheckSetSizeNode() {
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.activity, "Check set size expression");
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        int i = 0;
        Set<String> sets = this.setFragments.keySet();
        for (String setName : sets) {
            String setInstanceAnnotationSetName = "annotationSet_" + setName;
            PSCombinedFragment setFragment = this.setFragments.get(setName);
            PSNodeConstraint constraint = setFragment.getConstraint();
            ObjectVariable setObject = SDMUtil.createObject(SDMUtil.getAnnotationSetClass(), setInstanceAnnotationSetName, true, false, storyPattern);
            if (constraint instanceof PSMetricConstraint && "SIZE".equals(((PSMetricConstraint)constraint).getMetricAcronym())) {
                FindSetFragmentsStep.createSetConstraint((PSMetricConstraint)constraint, setObject);
            }
            i = this.addExpressionForNestedSet(storyPattern, i, setFragment);
        }
        return storyActivity;
    }

    private int addExpressionForNestedSet(StoryPattern storyPattern, int i, PSCombinedFragment setFragment) {
        for (PSCombinedFragmentItem child : setFragment.getChildren()) {
            if (!(child instanceof PSCombinedFragment)) continue;
            String setName = "annotationSet_" + this.getNameForSet(setFragment);
            String methodName = "getSizeOfNestedSet_" + i + "_" + this.getNameForSet(setFragment);
            EClass engineClass = this.generator.getEngineClass(this.pattern);
            EOperation _GSONSoperation = EcoreUtil.addEOperation(engineClass, methodName);
            _GSONSoperation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
            EcoreUtil.addEParameter(_GSONSoperation, setName, (EClassifier)AnnotationsPackage.Literals.ANNOTATION_SET);
            EcoreUtil.addEParameter(_GSONSoperation, "this", (EClassifier)engineClass);
            Activity _GSONSactivity = this.generator.createActivity(_GSONSoperation, this.pattern);
            GetSizeOfNestedSetStep getSizeOfNestedSetGenerator = new GetSizeOfNestedSetStep(this.generator);
            getSizeOfNestedSetGenerator.generate(_GSONSactivity, setFragment, (PSCombinedFragment)child, setName, this.storyItems, this.counter);
            StringBuffer expression = new StringBuffer();
            expression.append(String.valueOf(methodName) + "(" + setName + ")");
            SDMUtil.createConstraint(expression.toString(), storyPattern);
            ++i;
            i = this.addExpressionForNestedSet(storyPattern, i, (PSCombinedFragment)child);
        }
        return i;
    }

    private String getNameForSet(PSCombinedFragment set) {
        for (String key : this.setFragments.keySet()) {
            if (!this.setFragments.get(key).equals(set)) continue;
            return key;
        }
        return "";
    }

    private ActivityNode addRemoveSetsNode() {
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.activity, "Remove annotation sets");
        for (String setName : this.annotationSets) {
            EClass classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
            ObjectVariable var = StorydrivenUtil.addObjectVariable(storyActivity, "annotationSet_" + setName, classifier);
            var.setBindingState(BindingState.BOUND);
            var.setBindingOperator(BindingOperator.DESTROY);
        }
        return storyActivity;
    }

    private ActivityNode createCreateResultActivity() {
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(this.activity, "Create Result Set");
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        ObjectVariable resultSet = SDMUtil.createSetResultSetObject(storyPattern, false, true);
        for (String setName : this.annotationSets) {
            ObjectVariable var;
            EClass classifier;
            if (setName.contains("_")) {
                classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
                var = StorydrivenUtil.addObjectVariable(storyActivity, "annotationSet_" + setName, classifier);
                var.setBindingState(BindingState.BOUND);
                var.setBindingOperator(BindingOperator.DESTROY);
                continue;
            }
            classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
            var = StorydrivenUtil.addObjectVariable(storyActivity, "annotationSet_" + setName, classifier);
            var.setBindingState(BindingState.BOUND);
            var.setBindingOperator(BindingOperator.CHECK_ONLY);
            SDMUtil.createLink(var, resultSet, AnnotationsPackage.eINSTANCE.getAnnotationSet_SetResultSet(), null, true, BindingSemantics.MANDATORY, storyPattern);
        }
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyActivity, "annotation", AnnotationsPackage.Literals.ASG_ANNOTATION);
        annotationVar.setBindingState(BindingState.BOUND);
        LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(storyActivity, annotationVar, resultSet, AnnotationsPackage.Literals.ASG_ANNOTATION__SET_RESULT_SET);
        linkVariable.setBindingOperator(BindingOperator.CREATE);
        return storyActivity;
    }
}

