/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.ExprUtil;
import org.reclipse.structure.generator.util.more.SDMUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.PSSpecificationConstraint;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.core.NamedElement;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityFinalNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.JunctionNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.CollectionVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class FindAdditionalElementsStep
implements Constants {
    private static final String OBJECT_IN_SET_PREFIX = "object_in_set__";
    private static final String SATISFIED_CONSTRAINT_NAME = "satisfiedConstraint";
    private final IGenerator generator;
    private Map<PSNode, ObjectVariable> storyItems;
    private Counter counter;
    private Activity activity;

    public FindAdditionalElementsStep(IGenerator generator) {
        this.generator = generator;
    }

    public void generate(Activity activity, PSPatternSpecification pattern) {
        StoryNode storyNode;
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)activity)});
        this.activity = activity;
        PSNode trigger = this.generator.getTrigger(pattern);
        this.storyItems = new HashMap<PSNode, ObjectVariable>();
        this.counter = new Counter();
        InitialNode initialNode = StorydrivenUtil.addInitialNode(activity);
        StoryNode lastActivity = storyNode = this.createAnnotationStoryActivity(trigger, AnnotationStoryType.REBIND, activity, false, this.storyItems, this.counter);
        ObjectVariable annoObject = (ObjectVariable)SDMUtil.findVariableByName(storyNode.getStoryPattern(), "annotation");
        EParameter param = StorydrivenUtil.getEParameter(activity, "annotation");
        annoObject.setBindingExpression(ExpressionsUtil.createParameterExpression(param));
        StorydrivenUtil.addTransition((ActivityNode)initialNode, (ActivityNode)lastActivity);
        HashSet<PSNode> nodesOfBoundObjects = new HashSet<PSNode>();
        HashSet<PSNode> nodesNotInFragments = new HashSet<PSNode>();
        HashSet<PSCombinedFragment> optionalFragments = new HashSet<PSCombinedFragment>();
        HashSet<PSSpecificationConstraint> constraintNotInFragments = new HashSet<PSSpecificationConstraint>();
        this.fillContainer(pattern, trigger, nodesOfBoundObjects, nodesNotInFragments, optionalFragments, constraintNotInFragments);
        lastActivity = this.createCheckOptionalAttrExprPairStoriesForNodes(nodesOfBoundObjects, (ActivityNode)lastActivity);
        lastActivity = this.createFindOptionalNodesAndCheckAttrExprPairsStoriesForNodes(nodesNotInFragments, nodesOfBoundObjects, (ActivityNode)lastActivity);
        lastActivity = this.createFindNodesInOptionalFragmentsStoriesForFragments(optionalFragments, nodesOfBoundObjects, (ActivityNode)lastActivity);
        lastActivity = this.createCheckOptionalConstraintStoriesForConstraints(constraintNotInFragments, (ActivityNode)lastActivity);
        ActivityFinalNode finalNode = StorydrivenUtil.addSuccessFinalNode(activity);
        this.createTransitionFromLastActivityToNextActivity((ActivityNode)lastActivity, (ActivityNode)finalNode);
    }

    private StoryNode createAnnotationStoryActivity(PSNode trigger, AnnotationStoryType purpose, Activity activity, boolean addSetResults, Map<PSNode, ObjectVariable> storyItems, Counter counter) {
        ObjectVariable annotationResultSet;
        PSPatternSpecification pattern = trigger.getPatternSpecification();
        PSAnnotation createAnnotation = ModelHelper.getCreateAnnotation((PSPatternSpecification)pattern);
        String storyPatternName = "";
        switch (purpose) {
            case CHECK: {
                storyPatternName = "Check if the matched pattern is already annotated and add it to the set";
                break;
            }
            case CREATE: {
                storyPatternName = "Create a new annotation for the matched pattern";
                break;
            }
            case REBIND: {
                storyPatternName = "Reconstruct the matched object structure";
            }
        }
        StoryNode storyActivity = StorydrivenUtil.addStoryNode(activity, storyPatternName);
        StoryPattern storyPattern = storyActivity.getStoryPattern();
        EClass createAnnotationType = this.generator.getAnnotationClass(createAnnotation.getType());
        ObjectVariable annotationObject = SDMUtil.createAnnotationObject(createAnnotation, createAnnotationType, AnnotationStoryType.REBIND.equals((Object)purpose), AnnotationStoryType.CREATE.equals((Object)purpose), storyPattern, storyItems, counter);
        if (AnnotationStoryType.REBIND.equals((Object)purpose)) {
            annotationObject.setName("annotation");
        }
        AnnotationStoryType.CREATE.equals((Object)purpose);
        HashMap<PSNode, ObjectVariable> annotatedObjects = new HashMap<PSNode, ObjectVariable>();
        if (!AnnotationStoryType.REBIND.equals((Object)purpose)) {
            for (PSConnection connection : createAnnotation.getOutgoing()) {
                if (!(connection instanceof PSLink)) continue;
                PSLink psLink = (PSLink)connection;
                PSNode targetNode = psLink.getTarget();
                ObjectVariable annotatedObject = (ObjectVariable)annotatedObjects.get(targetNode);
                if (annotatedObject == null) {
                    if (!AnnotationStoryType.CHECK.equals((Object)purpose) || targetNode.getParents().isEmpty() && !targetNode.getModifier().equals((Object)ModifierType.SET)) {
                        if (targetNode instanceof PSAnnotation) {
                            EClass annoType = this.generator.getAnnotationClass(((PSAnnotation)targetNode).getType());
                            annotatedObject = SDMUtil.createAnnotationObject((PSAnnotation)targetNode, annoType, true, false, storyPattern, storyItems, counter);
                        } else {
                            annotatedObject = SDMUtil.createObject((PSObject)targetNode, true, false, storyPattern, storyItems, counter);
                        }
                        if (ModelHelper.isSearchForThisOptional((PSNode)targetNode) && targetNode != trigger) {
                            annotatedObject.setBindingSemantics(BindingSemantics.OPTIONAL);
                        }
                    }
                    annotatedObjects.put(targetNode, annotatedObject);
                }
                ObjectVariable source = storyItems.get(psLink.getSource());
                ObjectVariable target = storyItems.get(psLink.getTarget());
                boolean addSetToResult = false;
                if ((source instanceof CollectionVariable || target instanceof CollectionVariable) && psLink.getInstanceOf() == AnnotationsPackage.Literals.ASG_ANNOTATION__ANNOTATED_ELEMENTS) {
                    addSetToResult = true;
                }
                if (AnnotationStoryType.CHECK.equals((Object)purpose) && (!targetNode.getParents().isEmpty() || targetNode.getModifier().equals((Object)ModifierType.SET))) continue;
                SDMUtil.createLink(source, target, psLink.getInstanceOf(), psLink.getQualifier(), AnnotationStoryType.CREATE.equals((Object)purpose) || addSetToResult, BindingSemantics.MANDATORY, storyPattern);
            }
        }
        for (PSSpecificationConstraint psConstraint : pattern.getConstraints()) {
            if (!psConstraint.getExpression().toLowerCase().startsWith("maybe")) continue;
            SDMUtil.createConstraint(psConstraint.getExpression(), storyPattern);
        }
        if (AnnotationStoryType.CREATE.equals((Object)purpose) || AnnotationStoryType.REBIND.equals((Object)purpose)) {
            this.linkBoundObjects(trigger, storyPattern, annotationObject, annotatedObjects, AnnotationStoryType.CREATE.equals((Object)purpose), !AnnotationStoryType.REBIND.equals((Object)purpose), !AnnotationStoryType.REBIND.equals((Object)purpose), storyItems, counter);
        }
        if (AnnotationStoryType.CREATE.equals((Object)purpose)) {
            annotationResultSet = SDMUtil.createAnnotationResultSetObject(storyPattern, true, false);
            SDMUtil.createAnnotationResultSetLink(annotationResultSet, annotationObject, true, storyPattern);
        } else if (AnnotationStoryType.CHECK.equals((Object)purpose)) {
            annotationResultSet = SDMUtil.createAnnotationResultSetObject(storyPattern, true, false);
            SDMUtil.createAnnotationResultSetLink(annotationResultSet, annotationObject, false, storyPattern);
        }
        if (addSetResults) {
            ObjectVariable setResult = SDMUtil.createSetResultSetObject(storyPattern, true, false);
            SDMUtil.createLink(annotationObject, setResult, AnnotationsPackage.Literals.ASG_ANNOTATION__SET_RESULT_SET, null, true, BindingSemantics.MANDATORY, storyPattern);
        }
        return storyActivity;
    }

    private void linkBoundObjects(PSNode trigger, StoryPattern storyPattern, ObjectVariable annotationObject, Map<PSNode, ObjectVariable> annotatedObjects, boolean bound, boolean addNodeExpressions, boolean linksAreCreate, Map<PSNode, ObjectVariable> storyItems, Counter counter) {
        PSPatternSpecification pattern = trigger.getPatternSpecification();
        for (PSNode psNode : pattern.getNodes()) {
            if (psNode == ModelHelper.getCreateAnnotation((PSPatternSpecification)pattern) || psNode.getModifier() == ModifierType.NEGATIVE) continue;
            if (psNode.getName() == null || psNode.getName().equals("")) {
                throw new IllegalStateException("PSNode object \"" + psNode + "\" has no name.");
            }
            ObjectVariable boundObject = annotatedObjects.get(psNode);
            if (boundObject == null && ModelHelper.isMatchingRequired((PSNode)psNode, (PSNode)trigger) && (addNodeExpressions || !ModelHelper.isAnnotatedOptionalNodeToBeCheckedLater((PSNode)psNode, (PSNode)trigger))) {
                if (psNode instanceof PSObject) {
                    boundObject = SDMUtil.createObject((PSObject)psNode, bound, addNodeExpressions, storyPattern, storyItems, counter);
                } else if (psNode instanceof PSAnnotation && !ModelHelper.isCreate((PSAnnotation)((PSAnnotation)psNode))) {
                    EClass annoType = this.generator.getAnnotationClass(((PSAnnotation)psNode).getType());
                    boundObject = SDMUtil.createAnnotationObject((PSAnnotation)psNode, annoType, bound, false, storyPattern, storyItems, counter);
                }
                if (psNode.equals(trigger) && ModifierType.ADDITIONAL.equals((Object)psNode.getModifier()) && boundObject != null) {
                    boundObject.setBindingSemantics(BindingSemantics.MANDATORY);
                }
            }
            if (boundObject == null) continue;
            SDMUtil.createBoundObjectsLink(annotationObject, boundObject, psNode, linksAreCreate, storyPattern);
        }
    }

    private ActivityNode createCheckOptionalAttrExprPairStoriesForNodes(Set<PSNode> nodes, ActivityNode lastActivity) {
        ActivityNode tmpLastActivity = lastActivity;
        ActivityNode forEachActivity = null;
        for (PSNode node : nodes) {
            boolean isASetWithOptionalAttrExprPairs;
            if (node.getModifier() == ModifierType.NEGATIVE) continue;
            boolean bl = isASetWithOptionalAttrExprPairs = node.getModifier() == ModifierType.SET && FindAdditionalElementsStep.hasOptionalAttrExprPairs(node);
            if (isASetWithOptionalAttrExprPairs) {
                tmpLastActivity = forEachActivity = this.createBindObjectsInSetActivity(node, tmpLastActivity, this.activity);
            }
            int index = 0;
            boolean firstExpr = true;
            for (PSNodeConstraint expr : node.getNodeConstraints()) {
                if (expr instanceof PSAttributeConstraint && ((PSAttributeConstraint)expr).isAdditional()) {
                    EdgeGuard transitionGuard = EdgeGuard.NONE;
                    if (isASetWithOptionalAttrExprPairs && firstExpr) {
                        transitionGuard = EdgeGuard.EACH_TIME;
                    } else if (FindAdditionalElementsStep.isForEachActivity(tmpLastActivity)) {
                        transitionGuard = EdgeGuard.END;
                    }
                    tmpLastActivity = this.createCheckOptionalAttrExprPairStory((PSAttributeConstraint)expr, index, tmpLastActivity, transitionGuard, this.activity);
                    firstExpr = false;
                }
                ++index;
            }
            if (!isASetWithOptionalAttrExprPairs) continue;
            SDMUtil.createTransition(tmpLastActivity, forEachActivity, EdgeGuard.NONE, this.activity);
            tmpLastActivity = forEachActivity;
            forEachActivity = null;
        }
        return tmpLastActivity;
    }

    private static boolean hasOptionalAttrExprPairs(PSNode node) {
        for (PSNodeConstraint expr : node.getNodeConstraints()) {
            if (!(expr instanceof PSAttributeConstraint) || !((PSAttributeConstraint)expr).isAdditional()) continue;
            return true;
        }
        return false;
    }

    private ActivityEdge createTransitionFromLastActivityToNextActivity(ActivityNode lastActivity, ActivityNode nextActivity) {
        EdgeGuard transitionGuard = EdgeGuard.NONE;
        if (FindAdditionalElementsStep.isForEachActivity(lastActivity)) {
            transitionGuard = EdgeGuard.END;
        }
        return SDMUtil.createTransition(lastActivity, nextActivity, transitionGuard, this.activity);
    }

    private static boolean isForEachActivity(ActivityNode activity) {
        return activity instanceof StoryNode && ((StoryNode)activity).isForEach();
    }

    private void fillContainer(PSPatternSpecification pattern, PSNode trigger, Set<PSNode> nodesOfBoundObjects, Set<PSNode> nodesNotInFragments, Set<PSCombinedFragment> optionalFragments, Set<PSSpecificationConstraint> constraintNotInFragments) {
        for (PSNode node : pattern.getNodes()) {
            if (node == ModelHelper.getCreateAnnotation((PSPatternSpecification)pattern)) continue;
            if (ModelHelper.isMatchingRequired((PSNode)node, (PSNode)trigger)) {
                if (ModelHelper.isAnnotatedOptionalNodeToBeCheckedLater((PSNode)node, (PSNode)trigger)) {
                    nodesNotInFragments.add(node);
                    continue;
                }
                nodesOfBoundObjects.add(node);
                continue;
            }
            if (ModelHelper.isWithinOptionalFragment((PSCombinedFragmentItem)node)) continue;
            nodesNotInFragments.add(node);
        }
        for (PSCombinedFragment fragment : pattern.getCombinedFragments()) {
            if (!ModifierType.ADDITIONAL.equals((Object)fragment.getKind())) continue;
            optionalFragments.add(fragment);
        }
        for (PSSpecificationConstraint constraint : pattern.getConstraints()) {
            if (ModelHelper.isWithinOptionalFragment((PSCombinedFragmentItem)constraint)) continue;
            constraintNotInFragments.add(constraint);
        }
    }

    private ActivityNode createCheckOptionalConstraintStoriesForConstraints(Set<PSSpecificationConstraint> constraints, ActivityNode lastActivity) {
        ActivityNode tmpLastActivity = lastActivity;
        for (PSSpecificationConstraint constraint : constraints) {
            if (!constraint.isAdditional()) continue;
            tmpLastActivity = this.createCheckOptionalConstraintStory(constraint, tmpLastActivity, this.activity);
        }
        return tmpLastActivity;
    }

    private ActivityNode createBindObjectsInSetActivity(PSNode setNode, ActivityNode lastActivity, Activity activity) {
        if (setNode.getModifier() != ModifierType.SET) {
            throw new IllegalArgumentException("The node argument has to represent a set.");
        }
        StoryNode bindObjectsInSetStoryActivity = StorydrivenUtil.addStoryNode(activity, "Bind an object of a set");
        StoryPattern bindObjectsInSetStoryPattern = bindObjectsInSetStoryActivity.getStoryPattern();
        bindObjectsInSetStoryActivity.setForEach(true);
        this.createTransitionFromLastActivityToNextActivity(lastActivity, (ActivityNode)bindObjectsInSetStoryActivity);
        PSAnnotation createAnnotation = ModelHelper.getCreateAnnotation((PSPatternSpecification)setNode.getPatternSpecification());
        EClass annoType = this.generator.getAnnotationClass(createAnnotation.getType());
        ObjectVariable annotationObject = SDMUtil.createAnnotationObject(createAnnotation, annoType, true, false, bindObjectsInSetStoryPattern, null, this.counter);
        annotationObject.setName("annotation");
        ObjectVariable boundObject = SDMUtil.createObject(setNode, false, false, bindObjectsInSetStoryPattern, this.storyItems, this.counter, this.generator);
        if (boundObject != null) {
            boundObject.setName(OBJECT_IN_SET_PREFIX + boundObject.getName());
            SDMUtil.createBoundObjectsLink(annotationObject, boundObject, setNode, false, bindObjectsInSetStoryPattern);
        }
        return bindObjectsInSetStoryActivity;
    }

    private ActivityNode createFindOptionalNodesAndCheckAttrExprPairsStoriesForNodes(Set<PSNode> nodesToFind, Set<PSNode> nodesOfBoundObjects, ActivityNode lastActivity) {
        ActivityNode tmpLastActivity = lastActivity;
        for (PSNode psNode : nodesToFind) {
            if (psNode.getModifier() != ModifierType.ADDITIONAL) continue;
            StoryNode findObjectStoryActivity = this.createFindObjectStoryActivity(psNode, nodesOfBoundObjects);
            this.createTransitionFromLastActivityToNextActivity(tmpLastActivity, (ActivityNode)findObjectStoryActivity);
            HashSet<Object> nodesSet = new HashSet<PSNode>(1);
            nodesSet.add(psNode);
            StoryNode rememberObjectStoryActivity = this.createRememberFoundObjectsStoryActivity(nodesSet);
            SDMUtil.createTransition((ActivityNode)findObjectStoryActivity, (ActivityNode)rememberObjectStoryActivity, EdgeGuard.SUCCESS, this.activity);
            JunctionNode nopActivity = SDMUtil.createNopActivity(this.activity);
            SDMUtil.createTransition((ActivityNode)findObjectStoryActivity, (ActivityNode)nopActivity, EdgeGuard.FAILURE, this.activity);
            StoryNode nextActivity = rememberObjectStoryActivity;
            if (psNode instanceof PSObject) {
                nodesSet = new HashSet(1);
                nodesSet.add(psNode);
                nextActivity = this.createCheckOptionalAttrExprPairStoriesForNodes(nodesSet, (ActivityNode)nextActivity);
            }
            this.createTransitionFromLastActivityToNextActivity((ActivityNode)nextActivity, (ActivityNode)nopActivity);
            tmpLastActivity = nopActivity;
        }
        return tmpLastActivity;
    }

    private ActivityNode createFindNodesInOptionalFragmentsStoriesForFragments(Set<PSCombinedFragment> fragments, Set<PSNode> nodesOfBoundObjects, ActivityNode lastActivity) {
        ActivityNode tmpLastActivity = lastActivity;
        for (PSCombinedFragment fragment : fragments) {
            HashSet<PSNode> notOptionalChildNodes = new HashSet<PSNode>();
            HashSet<PSNode> optionalChildNodes = new HashSet<PSNode>();
            HashSet<PSSpecificationConstraint> constraints = new HashSet<PSSpecificationConstraint>();
            for (PSCombinedFragmentItem child : fragment.getChildren()) {
                if (child instanceof PSNode) {
                    if (((PSNode)child).getModifier() == ModifierType.ADDITIONAL) {
                        optionalChildNodes.add((PSNode)child);
                        continue;
                    }
                    notOptionalChildNodes.add((PSNode)child);
                    continue;
                }
                if (!(child instanceof PSSpecificationConstraint)) continue;
                constraints.add((PSSpecificationConstraint)child);
            }
            StoryNode findObjectsActivity = this.createFindObjectsInFragmentStoryActivity(constraints, notOptionalChildNodes, nodesOfBoundObjects, this.activity, this.storyItems, this.counter);
            this.createTransitionFromLastActivityToNextActivity(tmpLastActivity, (ActivityNode)findObjectsActivity);
            StoryNode rememberObjectsActivity = this.createRememberFoundObjectsStoryActivity(notOptionalChildNodes);
            SDMUtil.createTransition((ActivityNode)findObjectsActivity, (ActivityNode)rememberObjectsActivity, EdgeGuard.SUCCESS, this.activity);
            StoryNode nextActivity = rememberObjectsActivity;
            nextActivity = this.createCheckOptionalAttrExprPairStoriesForNodes(notOptionalChildNodes, (ActivityNode)nextActivity);
            HashSet<PSNode> newSetOfNodesOfBoundObjects = new HashSet<PSNode>(nodesOfBoundObjects);
            for (PSNode node : notOptionalChildNodes) {
                if (node.getModifier() == ModifierType.NEGATIVE) continue;
                newSetOfNodesOfBoundObjects.add(node);
            }
            nextActivity = this.createFindOptionalNodesAndCheckAttrExprPairsStoriesForNodes(optionalChildNodes, newSetOfNodesOfBoundObjects, (ActivityNode)nextActivity);
            nextActivity = this.createCheckOptionalConstraintStoriesForConstraints(constraints, (ActivityNode)nextActivity);
            JunctionNode nopActivity = SDMUtil.createNopActivity(this.activity);
            SDMUtil.createTransition((ActivityNode)findObjectsActivity, (ActivityNode)nopActivity, EdgeGuard.FAILURE, this.activity);
            this.createTransitionFromLastActivityToNextActivity((ActivityNode)nextActivity, (ActivityNode)nopActivity);
            tmpLastActivity = nopActivity;
        }
        return tmpLastActivity;
    }

    private ActivityNode createCheckOptionalConstraintStory(PSSpecificationConstraint constraint, ActivityNode lastActivity, Activity activity) {
        if (!constraint.isAdditional()) {
            throw new IllegalArgumentException("Constraint must be optional.");
        }
        if (constraint.getName() == null || constraint.getName().equals("")) {
            throw new IllegalStateException("PSConstraint object \"" + constraint + "\" has no name.");
        }
        StoryNode checkConstraintStoryActivity = StorydrivenUtil.addStoryNode(activity, "Check constraint");
        StoryPattern checkConstraintStoryPattern = checkConstraintStoryActivity.getStoryPattern();
        SDMUtil.createConstraint(constraint.getExpression(), checkConstraintStoryPattern);
        this.createTransitionFromLastActivityToNextActivity(lastActivity, (ActivityNode)checkConstraintStoryActivity);
        StoryNode constraintSatisfiedStoryActivity = StorydrivenUtil.addStoryNode(activity, "Remember constraint is satisfied");
        StoryPattern constraintSatisfiedStoryPattern = constraintSatisfiedStoryActivity.getStoryPattern();
        PSAnnotation anno = ModelHelper.getCreateAnnotation((PSPatternSpecification)constraint.getPatternSpecification());
        ObjectVariable annotationObject = SDMUtil.createObject((PSNode)anno, true, false, constraintSatisfiedStoryPattern, this.storyItems, this.counter, this.generator);
        annotationObject.setName("annotation");
        SDMUtil.createTransition((ActivityNode)checkConstraintStoryActivity, (ActivityNode)constraintSatisfiedStoryActivity, EdgeGuard.SUCCESS, activity);
        JunctionNode nopActivity = SDMUtil.createNopActivity(activity);
        SDMUtil.createTransition((ActivityNode)checkConstraintStoryActivity, (ActivityNode)nopActivity, EdgeGuard.FAILURE, activity);
        SDMUtil.createTransition((ActivityNode)constraintSatisfiedStoryActivity, (ActivityNode)nopActivity, EdgeGuard.NONE, activity);
        return nopActivity;
    }

    private ActivityNode createCheckOptionalAttrExprPairStory(PSAttributeConstraint optionalAttrExprPair, int exprID, ActivityNode lastActivity, EdgeGuard transitionGuard, Activity activity) {
        if (!optionalAttrExprPair.isAdditional()) {
            throw new IllegalArgumentException("Expression must be optional.");
        }
        StoryNode checkExprStoryActivity = StorydrivenUtil.addStoryNode(activity, "Check AttrExprPair " + exprID);
        StoryPattern checkExprStoryPattern = checkExprStoryActivity.getStoryPattern();
        PSObject psObject = (PSObject)optionalAttrExprPair.getNode();
        ObjectVariable object = SDMUtil.createObject(psObject, true, false, checkExprStoryPattern, this.storyItems, this.counter);
        if (psObject.getModifier() == ModifierType.SET) {
            object.setName(OBJECT_IN_SET_PREFIX + object.getName());
        }
        SDMUtil.createAttributeExpression(optionalAttrExprPair, object);
        SDMUtil.createTransition(lastActivity, (ActivityNode)checkExprStoryActivity, transitionGuard, activity);
        StoryNode exprSatisfiedStoryActivity = StorydrivenUtil.addStoryNode(activity, "Remember expression is satisfied");
        StoryPattern exprSatisfiedStoryPattern = exprSatisfiedStoryActivity.getStoryPattern();
        PSAnnotation createAnnotation = ModelHelper.getCreateAnnotation((PSPatternSpecification)optionalAttrExprPair.getNode().getPatternSpecification());
        ObjectVariable annotationObject = SDMUtil.createObject((PSNode)createAnnotation, true, false, exprSatisfiedStoryPattern, this.storyItems, this.counter, this.generator);
        annotationObject.setName("annotation");
        ObjectVariable satisfiedConstraint = SDMUtil.createObject(AnnotationsPackage.eINSTANCE.getSatisfiedAttributeConstraint(), SATISFIED_CONSTRAINT_NAME, false, true, exprSatisfiedStoryPattern);
        SDMUtil.createAttributeAssignment(satisfiedConstraint, AnnotationsPackage.eINSTANCE.getSatisfiedAttributeConstraint_AttributeIndex(), (Expression)ExprUtil.eInt(exprID));
        SDMUtil.createAttributeAssignment(satisfiedConstraint, AnnotationsPackage.eINSTANCE.getSatisfiedAttributeConstraint_NodeID(), (Expression)ExprUtil.eString(optionalAttrExprPair.getNode().getName()));
        ObjectVariable ownerNodeObject = SDMUtil.createObject(psObject.getInstanceOf(), psObject.getName(), true, false, exprSatisfiedStoryPattern);
        SDMUtil.createLink(satisfiedConstraint, ownerNodeObject, AnnotationsPackage.eINSTANCE.getSatisfiedAttributeConstraint_Context(), null, true, BindingSemantics.MANDATORY, exprSatisfiedStoryPattern);
        SDMUtil.createLink(annotationObject, satisfiedConstraint, AnnotationsPackage.eINSTANCE.getASGAnnotation_SatisfiedConstraints(), null, true, BindingSemantics.MANDATORY, exprSatisfiedStoryPattern);
        SDMUtil.createTransition((ActivityNode)checkExprStoryActivity, (ActivityNode)exprSatisfiedStoryActivity, EdgeGuard.SUCCESS, activity);
        JunctionNode nopActivity = SDMUtil.createNopActivity(activity);
        SDMUtil.createTransition((ActivityNode)checkExprStoryActivity, (ActivityNode)nopActivity, EdgeGuard.FAILURE, activity);
        SDMUtil.createTransition((ActivityNode)exprSatisfiedStoryActivity, (ActivityNode)nopActivity, EdgeGuard.NONE, activity);
        return nopActivity;
    }

    private StoryNode createFindObjectsInFragmentStoryActivity(Set<PSSpecificationConstraint> constraints, Set<PSNode> notOptionalChildNodes, Set<PSNode> nodesOfBoundObjects, Activity activity, Map<PSNode, ObjectVariable> storyItems, Counter counter) {
        StoryNode findObjectsInFragmentStoryActivity = StorydrivenUtil.addStoryNode(activity, "Try finding object(s) in optional fragment");
        StoryPattern findObjectsInFragmentStoryPattern = findObjectsInFragmentStoryActivity.getStoryPattern();
        HashMap<PSNode, ObjectVariable> nodesOfAddedObjects = new HashMap<PSNode, ObjectVariable>();
        for (PSNode psNode : notOptionalChildNodes) {
            ObjectVariable theObjectToFind = null;
            if (nodesOfAddedObjects.containsKey(psNode)) continue;
            if (psNode instanceof PSObject) {
                theObjectToFind = SDMUtil.createObject((PSObject)psNode, false, true, findObjectsInFragmentStoryPattern, storyItems, counter);
            } else if (psNode instanceof PSAnnotation) {
                theObjectToFind = SDMUtil.createObject(psNode, false, false, findObjectsInFragmentStoryPattern, storyItems, counter, this.generator);
            }
            if (psNode.getModifier() == ModifierType.ADDITIONAL && theObjectToFind != null) {
                theObjectToFind.setBindingSemantics(BindingSemantics.MANDATORY);
            }
            nodesOfAddedObjects.put(psNode, theObjectToFind);
            this.addLinkedBoundObjects(psNode, true, nodesOfAddedObjects, nodesOfBoundObjects, findObjectsInFragmentStoryPattern, storyItems, counter);
            this.addLinkedBoundObjects(psNode, false, nodesOfAddedObjects, nodesOfBoundObjects, findObjectsInFragmentStoryPattern, storyItems, counter);
        }
        HashSet<PSConnection> addedConnections = new HashSet<PSConnection>();
        for (PSNode psNode : notOptionalChildNodes) {
            this.connectObject(psNode, true, nodesOfAddedObjects, addedConnections, findObjectsInFragmentStoryPattern);
            this.connectObject(psNode, false, nodesOfAddedObjects, addedConnections, findObjectsInFragmentStoryPattern);
        }
        for (PSSpecificationConstraint constraint : constraints) {
            if (constraint.isAdditional()) continue;
            SDMUtil.createConstraint(constraint.getExpression(), findObjectsInFragmentStoryPattern);
        }
        return findObjectsInFragmentStoryActivity;
    }

    private StoryNode createFindObjectStoryActivity(PSNode psNode, Set<PSNode> nodesOfBoundObjects) {
        StoryNode findObjectStoryActivity = StorydrivenUtil.addStoryNode(this.activity, "Try finding object");
        StoryPattern findObjectStoryPattern = findObjectStoryActivity.getStoryPattern();
        HashMap<PSNode, ObjectVariable> nodesOfAddedObjects = new HashMap<PSNode, ObjectVariable>();
        ObjectVariable theObjectToFind = null;
        if (psNode instanceof PSObject) {
            theObjectToFind = SDMUtil.createObject((PSObject)psNode, false, true, findObjectStoryPattern, this.storyItems, this.counter);
        } else if (psNode instanceof PSAnnotation) {
            PSAnnotation anno = (PSAnnotation)psNode;
            EClass annoType = this.generator.getAnnotationClass(anno.getType());
            theObjectToFind = SDMUtil.createAnnotationObject(anno, annoType, false, false, findObjectStoryPattern, this.storyItems, this.counter);
        }
        if (psNode.getModifier() == ModifierType.ADDITIONAL && theObjectToFind != null) {
            theObjectToFind.setBindingSemantics(BindingSemantics.MANDATORY);
        }
        nodesOfAddedObjects.put(psNode, theObjectToFind);
        this.addLinkedBoundObjects(psNode, true, nodesOfAddedObjects, nodesOfBoundObjects, findObjectStoryPattern, this.storyItems, this.counter);
        this.addLinkedBoundObjects(psNode, false, nodesOfAddedObjects, nodesOfBoundObjects, findObjectStoryPattern, this.storyItems, this.counter);
        this.connectObject(psNode, true, nodesOfAddedObjects, null, findObjectStoryPattern);
        this.connectObject(psNode, false, nodesOfAddedObjects, null, findObjectStoryPattern);
        return findObjectStoryActivity;
    }

    private void addLinkedBoundObjects(PSNode psNode, boolean targetObjects, Map<PSNode, ObjectVariable> nodesOfAddedObjects, Set<PSNode> nodesOfBoundObjects, StoryPattern storyPattern, Map<PSNode, ObjectVariable> storyItems, Counter counter) {
        ObjectVariable connectedObject = null;
        Iterator connectionIter = targetObjects ? psNode.getOutgoing().iterator() : psNode.getIncoming().iterator();
        while (connectionIter.hasNext()) {
            PSNode connectedNode;
            PSConnection connection = (PSConnection)connectionIter.next();
            PSNode pSNode = connectedNode = targetObjects ? connection.getTarget() : connection.getSource();
            if (!nodesOfBoundObjects.contains(connectedNode) || nodesOfAddedObjects != null && nodesOfAddedObjects.containsKey(connectedNode)) continue;
            connectedObject = SDMUtil.createObject(connectedNode, true, false, storyPattern, storyItems, counter, this.generator);
            if (psNode.getModifier() == ModifierType.ADDITIONAL && connectedObject != null) {
                connectedObject.setBindingSemantics(BindingSemantics.MANDATORY);
            }
            if (nodesOfAddedObjects == null) continue;
            nodesOfAddedObjects.put(connectedNode, connectedObject);
        }
    }

    private void connectObject(PSNode psNode, boolean targetObjects, Map<PSNode, ObjectVariable> nodesOfAddedObjects, Set<PSConnection> addedConnections, StoryPattern storyPattern) {
        Iterator connectionIter = targetObjects ? psNode.getOutgoing().iterator() : psNode.getIncoming().iterator();
        while (connectionIter.hasNext()) {
            PSConnection connection = (PSConnection)connectionIter.next();
            PSNode connectedNode = targetObjects ? connection.getTarget() : connection.getSource();
            ObjectVariable object = nodesOfAddedObjects.get(psNode);
            ObjectVariable connectedObject = nodesOfAddedObjects.get(connectedNode);
            if (object == null || connectedObject == null || addedConnections != null && addedConnections.contains(connection)) continue;
            if (connection instanceof PSLink) {
                PSLink psLink = (PSLink)connection;
                String role = null;
                if (psNode instanceof PSAnnotation) {
                    role = psLink.getQualifier();
                }
                if (targetObjects) {
                    SDMUtil.createLink(object, connectedObject, psLink.getInstanceOf(), role, false, BindingSemantics.MANDATORY, storyPattern);
                } else {
                    SDMUtil.createLink(connectedObject, object, psLink.getInstanceOf(), role, false, BindingSemantics.MANDATORY, storyPattern);
                }
            } else if (connection instanceof PSPath) {
                if (targetObjects) {
                    SDMUtil.createPath((PSPath)connection, object, connectedObject, storyPattern);
                } else {
                    SDMUtil.createPath((PSPath)connection, connectedObject, object, storyPattern);
                }
            }
            if (addedConnections == null) continue;
            addedConnections.add(connection);
        }
    }

    private StoryNode createRememberFoundObjectsStoryActivity(Set<PSNode> nodesOfObjectsFound) {
        StoryNode rememberObjectStoryActivity = StorydrivenUtil.addStoryNode(this.activity, "Remember the object(s) found");
        StoryPattern rememberObjectStoryPattern = rememberObjectStoryActivity.getStoryPattern();
        if (!nodesOfObjectsFound.isEmpty()) {
            PSNode aNode = nodesOfObjectsFound.iterator().next();
            PSAnnotation createAnnotation = ModelHelper.getCreateAnnotation((PSPatternSpecification)aNode.getPatternSpecification());
            EClass annoType = this.generator.getAnnotationClass(createAnnotation.getType());
            ObjectVariable annotationObject = SDMUtil.createAnnotationObject(createAnnotation, annoType, true, false, rememberObjectStoryPattern, null, this.counter);
            annotationObject.setName("annotation");
            for (PSNode psNode : nodesOfObjectsFound) {
                if (psNode.getModifier() == ModifierType.NEGATIVE) continue;
                ObjectVariable boundObject = SDMUtil.createObject(psNode, true, false, rememberObjectStoryPattern, this.storyItems, this.counter, this.generator);
                if (psNode.getModifier() == ModifierType.ADDITIONAL && boundObject != null) {
                    boundObject.setBindingSemantics(BindingSemantics.MANDATORY);
                }
                SDMUtil.createBoundObjectsLink(annotationObject, boundObject, psNode, true, rememberObjectStoryPattern);
                if (!(psNode instanceof PSAnnotation)) continue;
                this.createAntecedentAnnosLink(annotationObject, boundObject, rememberObjectStoryPattern);
            }
        }
        return rememberObjectStoryActivity;
    }

    private void createAntecedentAnnosLink(ObjectVariable annotationObject, ObjectVariable annotatedObject, StoryPattern storyPattern) {
        EReference assoc = AnnotationsPackage.Literals.ASG_ANNOTATION__ANTECEDENT_ANNOS;
        SDMUtil.createLink(annotationObject, annotatedObject, assoc, null, true, BindingSemantics.MANDATORY, storyPattern);
    }

    private static enum AnnotationStoryType {
        CHECK,
        CREATE,
        REBIND;

    }
}

