/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.steps;

import java.util.HashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.fujaba.commons.identifier.Identifier;
import org.reclipse.structure.generator.util.ExpressionsUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.generator.util.StorydrivenUtil;
import org.reclipse.structure.generator.util.more.Counter;
import org.reclipse.structure.generator.util.more.SDMUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSBooleanConstraint;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.PSPath;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.util.ModelHelper;
import org.reclipse.structure.specification.util.SpecificationUtil;
import org.storydriven.core.NamedElement;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityCallNode;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.calls.Callable;
import org.storydriven.storydiagrams.calls.Invocation;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;

public class AnnotateStep {
    private static final String START = "start";
    private static final String MATCH_CORE_NODES = "match_core_nodes";
    private static final String MATCH_NEGATIVE_FRAGMENT = "match_negative_fragment";
    private static final String MATCH_REQUIRED_SET_NODES = "match_required_set_nodes";
    private static final String BIND_MATCHED_NODES = "bind_matched_nodes";
    private static final String PREPARE_SET_FRAGMENT_FINDING = "prepare_set_fragment_finding";
    private static final String FIND_SET_FRAGMENTS = "find_set_fragments";
    private static final String CHECK_SET_FRAGMENT_RESULTS = "check_set_fragment_results";
    private static final String CHECK_FOR_EXISTING_ANNOTATION = "check for existing annotation";
    private static final String ADD_ANNOTATION = "add_annotation";
    private static final String STORE_ANTECEDENTS = "store_antecedents";
    private static final String FIND_ADDITIONAL_ELEMENTS = "find_additional_elements";
    private static final String DESTROY_INVALID_ANNOTATION = "destroy_invalid_annotation";
    private static final String END = "end";
    private final IGenerator generator;
    private Activity activity;
    private PSPatternSpecification pattern;
    private ObjectVariable createdAnnotationVariable;
    private PrimitiveVariable createdSetResultCheckVariable;

    public AnnotateStep(IGenerator generator) {
        this.generator = generator;
    }

    public void generate(Activity activity, PSPatternSpecification pattern) {
        this.generator.debug("Generating '%1s'...", new Object[]{NameUtil.getName((NamedElement)activity)});
        HashMap<String, ActivityNode> nodeCache = new HashMap<String, ActivityNode>();
        this.createdAnnotationVariable = null;
        this.createdSetResultCheckVariable = null;
        this.activity = activity;
        this.pattern = pattern;
        boolean hasNegativeFragments = SpecificationUtil.hasNegativeFragments((PSPatternSpecification)pattern);
        boolean hasSetFragments = SpecificationUtil.hasSetFragments((PSPatternSpecification)pattern);
        boolean hasAntecedentPatterns = SpecificationUtil.hasAntecedentPatterns((PSPatternSpecification)pattern);
        boolean hasAdditionalElements = SpecificationUtil.isAdditionalElements((PSPatternSpecification)pattern);
        nodeCache.put(START, this.createStartNode());
        nodeCache.put(MATCH_CORE_NODES, this.createMatchCoreNodes());
        if (hasNegativeFragments) {
            for (PSCombinedFragment fragment : pattern.getCombinedFragments()) {
                if (!ModifierType.NEGATIVE.equals((Object)fragment.getKind())) continue;
                ActivityNode activityNode = this.createMatchNegativeFragment(fragment);
                if (nodeCache.containsKey(MATCH_NEGATIVE_FRAGMENT)) {
                    StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(MATCH_NEGATIVE_FRAGMENT), activityNode, EdgeGuard.FAILURE);
                } else {
                    StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(MATCH_CORE_NODES), activityNode, EdgeGuard.EACH_TIME);
                }
                StorydrivenUtil.addTransition(activityNode, (ActivityNode)nodeCache.get(MATCH_CORE_NODES), EdgeGuard.SUCCESS);
                nodeCache.put(MATCH_NEGATIVE_FRAGMENT, activityNode);
            }
        }
        if (hasSetFragments) {
            nodeCache.put(MATCH_REQUIRED_SET_NODES, this.createMatchRequiredSetNodes());
        }
        nodeCache.put(BIND_MATCHED_NODES, this.createBindMatchedNodes());
        if (hasSetFragments) {
            nodeCache.put(PREPARE_SET_FRAGMENT_FINDING, this.createPrepareSetFragmentFinding());
            nodeCache.put(FIND_SET_FRAGMENTS, this.createFindSetFragments());
            nodeCache.put(CHECK_SET_FRAGMENT_RESULTS, this.createCheckSetFragmentResults());
        }
        nodeCache.put(CHECK_FOR_EXISTING_ANNOTATION, this.createCheckForExistingAnnotation());
        nodeCache.put(ADD_ANNOTATION, this.createAddAnnotation());
        if (hasAntecedentPatterns) {
            nodeCache.put(STORE_ANTECEDENTS, this.createStoreAntecedents());
        }
        if (hasAdditionalElements) {
            nodeCache.put(FIND_ADDITIONAL_ELEMENTS, this.createFindAdditionalElements());
        }
        nodeCache.put(DESTROY_INVALID_ANNOTATION, this.createDestroyInvalidAnnotation());
        nodeCache.put(END, this.createEnd());
        ActivityNode source = (ActivityNode)nodeCache.get(START);
        ActivityNode target = (ActivityNode)nodeCache.get(MATCH_CORE_NODES);
        StorydrivenUtil.addTransition(source, target);
        StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(CHECK_FOR_EXISTING_ANNOTATION), (ActivityNode)nodeCache.get(DESTROY_INVALID_ANNOTATION), EdgeGuard.SUCCESS);
        StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(CHECK_FOR_EXISTING_ANNOTATION), (ActivityNode)nodeCache.get(ADD_ANNOTATION), EdgeGuard.FAILURE);
        if (hasSetFragments) {
            if (hasNegativeFragments) {
                source = (ActivityNode)nodeCache.get(MATCH_NEGATIVE_FRAGMENT);
                target = (ActivityNode)nodeCache.get(MATCH_REQUIRED_SET_NODES);
                StorydrivenUtil.addTransition(source, target, EdgeGuard.FAILURE);
            } else {
                source = (ActivityNode)nodeCache.get(MATCH_CORE_NODES);
                target = (ActivityNode)nodeCache.get(MATCH_REQUIRED_SET_NODES);
                StorydrivenUtil.addTransition(source, target, EdgeGuard.EACH_TIME);
            }
            source = (ActivityNode)nodeCache.get(MATCH_REQUIRED_SET_NODES);
            target = (ActivityNode)nodeCache.get(BIND_MATCHED_NODES);
            StorydrivenUtil.addTransition(source, target, EdgeGuard.SUCCESS);
            source = (ActivityNode)nodeCache.get(MATCH_REQUIRED_SET_NODES);
            target = (ActivityNode)nodeCache.get(DESTROY_INVALID_ANNOTATION);
            StorydrivenUtil.addTransition(source, target, EdgeGuard.FAILURE);
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(BIND_MATCHED_NODES), (ActivityNode)nodeCache.get(PREPARE_SET_FRAGMENT_FINDING));
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(PREPARE_SET_FRAGMENT_FINDING), (ActivityNode)nodeCache.get(FIND_SET_FRAGMENTS));
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(FIND_SET_FRAGMENTS), (ActivityNode)nodeCache.get(CHECK_SET_FRAGMENT_RESULTS));
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(CHECK_SET_FRAGMENT_RESULTS), (ActivityNode)nodeCache.get(CHECK_FOR_EXISTING_ANNOTATION), EdgeGuard.SUCCESS);
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(CHECK_SET_FRAGMENT_RESULTS), (ActivityNode)nodeCache.get(DESTROY_INVALID_ANNOTATION), EdgeGuard.FAILURE);
        } else {
            if (hasNegativeFragments) {
                StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(MATCH_NEGATIVE_FRAGMENT), (ActivityNode)nodeCache.get(BIND_MATCHED_NODES), EdgeGuard.FAILURE);
            } else {
                StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(MATCH_CORE_NODES), (ActivityNode)nodeCache.get(BIND_MATCHED_NODES), EdgeGuard.EACH_TIME);
            }
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(BIND_MATCHED_NODES), (ActivityNode)nodeCache.get(CHECK_FOR_EXISTING_ANNOTATION));
        }
        if (hasAntecedentPatterns) {
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(ADD_ANNOTATION), (ActivityNode)nodeCache.get(STORE_ANTECEDENTS), EdgeGuard.END);
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(STORE_ANTECEDENTS), (ActivityNode)nodeCache.get(MATCH_CORE_NODES));
        } else {
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(ADD_ANNOTATION), (ActivityNode)nodeCache.get(MATCH_CORE_NODES), EdgeGuard.END);
        }
        if (hasAdditionalElements) {
            if (hasAntecedentPatterns) {
                StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(STORE_ANTECEDENTS), (ActivityNode)nodeCache.get(FIND_ADDITIONAL_ELEMENTS));
            } else {
                StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(ADD_ANNOTATION), (ActivityNode)nodeCache.get(FIND_ADDITIONAL_ELEMENTS), EdgeGuard.END);
            }
            StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(FIND_ADDITIONAL_ELEMENTS), (ActivityNode)nodeCache.get(DESTROY_INVALID_ANNOTATION));
        }
        StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(DESTROY_INVALID_ANNOTATION), (ActivityNode)nodeCache.get(MATCH_CORE_NODES));
        StorydrivenUtil.addTransition((ActivityNode)nodeCache.get(MATCH_CORE_NODES), (ActivityNode)nodeCache.get(END), EdgeGuard.END);
    }

    private ActivityNode createEnd() {
        return StorydrivenUtil.addActivityFinalNode(this.activity, "this.foundAnnotations");
    }

    private ActivityNode createStartNode() {
        return StorydrivenUtil.addInitialNode(this.activity);
    }

    private ActivityNode createMatchCoreNodes() {
        PSNode triggerNode = this.generator.getTrigger(this.pattern);
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Match Core Nodes");
        storyNode.setForEach(true);
        HashMap<PSNode, ObjectVariable> cache = new HashMap<PSNode, ObjectVariable>();
        for (PSNode node : this.pattern.getNodes()) {
            if (!SpecificationUtil.isCore((PSNode)node)) continue;
            String name = node.getName();
            EClass classifier = null;
            if (node instanceof PSAnnotation) {
                classifier = this.generator.getAnnotationClass(((PSAnnotation)node).getType());
            } else if (node instanceof PSObject) {
                classifier = ((PSObject)node).getInstanceOf();
            }
            ObjectVariable variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            if (ModifierType.NEGATIVE.equals((Object)node.getModifier())) {
                variable.setBindingSemantics(BindingSemantics.NEGATIVE);
            }
            if (node.equals(triggerNode)) {
                variable.setBindingExpression(ExpressionsUtil.getContextBindingExpression(this.activity));
                variable.setBindingState(BindingState.BOUND);
            }
            for (PSNodeConstraint constraint : node.getNodeConstraints()) {
                if (!(constraint instanceof PSBooleanConstraint) || ((PSBooleanConstraint)constraint).isAdditional()) continue;
                StorydrivenUtil.addConstraint(variable, (PSBooleanConstraint)constraint);
            }
            cache.put(node, variable);
        }
        StorydrivenUtil.connectAllVariables(this.pattern, storyNode, cache);
        return storyNode;
    }

    private ActivityNode createMatchNegativeFragment(PSCombinedFragment fragment) {
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Match Negative Fragment '%1s'", NameUtil.getName((Identifier)fragment));
        HashMap<PSNode, ObjectVariable> items = new HashMap<PSNode, ObjectVariable>();
        Counter counter = new Counter();
        for (PSNode item : ModelHelper.getNodes((PSCombinedFragment)fragment)) {
            SDMUtil.createObject(item, false, false, storyNode.getStoryPattern(), items, counter, this.generator);
        }
        for (PSConnection con : ModelHelper.getConnections(items.keySet())) {
            ObjectVariable target;
            ObjectVariable source = (ObjectVariable)items.get(con.getSource());
            if (source == null) {
                source = SDMUtil.createObject(con.getSource(), true, false, storyNode.getStoryPattern(), items, counter, this.generator);
            }
            if ((target = (ObjectVariable)items.get(con.getTarget())) == null) {
                target = SDMUtil.createObject(con.getTarget(), true, false, storyNode.getStoryPattern(), items, counter, this.generator);
            }
            if (con instanceof PSLink) {
                PSLink link = (PSLink)con;
                SDMUtil.createLink(source, target, link.getInstanceOf(), link.getQualifier(), false, BindingSemantics.MANDATORY, storyNode.getStoryPattern());
                continue;
            }
            if (!(con instanceof PSPath)) continue;
            SDMUtil.createPath((PSPath)con, source, target, storyNode.getStoryPattern());
        }
        return storyNode;
    }

    private ActivityNode createMatchRequiredSetNodes() {
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Match Required Set Nodes");
        HashMap<PSNode, ObjectVariable> coreCache = new HashMap<PSNode, ObjectVariable>();
        HashMap<PSNode, ObjectVariable> setCache = new HashMap<PSNode, ObjectVariable>();
        for (PSNode node : this.pattern.getNodes()) {
            ObjectVariable variable;
            String name = node.getName();
            EClass classifier = null;
            if (node instanceof PSAnnotation) {
                classifier = this.generator.getAnnotationClass(((PSAnnotation)node).getType());
            } else if (node instanceof PSObject) {
                classifier = ((PSObject)node).getInstanceOf();
            }
            if (SpecificationUtil.isCore((PSNode)node) && SpecificationUtil.isConnectedToSet((PSNode)node)) {
                variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
                variable.setBindingState(BindingState.BOUND);
                coreCache.put(node, variable);
                continue;
            }
            if (!SpecificationUtil.isInSet((PSNode)node)) continue;
            variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            if (ModifierType.NEGATIVE.equals((Object)node.getModifier())) {
                variable.setBindingSemantics(BindingSemantics.NEGATIVE);
            }
            for (PSNodeConstraint constraint : node.getNodeConstraints()) {
                if (!(constraint instanceof PSBooleanConstraint) || ((PSBooleanConstraint)constraint).isAdditional()) continue;
                StorydrivenUtil.addConstraint(variable, (PSBooleanConstraint)constraint);
            }
            setCache.put(node, variable);
        }
        StorydrivenUtil.connectVariables(this.pattern, storyNode, coreCache, setCache);
        return storyNode;
    }

    private ActivityNode createBindMatchedNodes() {
        boolean hasSetFragments = SpecificationUtil.hasSetFragments((PSPatternSpecification)this.pattern);
        PSAnnotation createAnnotation = SpecificationUtil.getCreateAnnotation((PSPatternSpecification)this.pattern);
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Bind Matched Nodes To New Annotation");
        String name = StorydrivenUtil.getValidName(this.pattern, "annotation");
        EClass classifier = this.generator.getAnnotationClass(this.pattern);
        this.createdAnnotationVariable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        this.createdAnnotationVariable.setBindingOperator(BindingOperator.CREATE);
        for (PSNode node : this.pattern.getNodes()) {
            LinkVariable linkVariable;
            ObjectVariable var;
            name = node.getName();
            classifier = null;
            if (node instanceof PSAnnotation) {
                classifier = this.generator.getAnnotationClass(((PSAnnotation)node).getType());
            } else if (node instanceof PSObject) {
                classifier = ((PSObject)node).getInstanceOf();
            }
            if (SpecificationUtil.isNormal((PSNode)node) && !createAnnotation.equals(node)) {
                var = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
                var.setBindingState(BindingState.BOUND);
                linkVariable = StorydrivenUtil.addLinkVariable(storyNode, this.createdAnnotationVariable, var, AnnotationsPackage.Literals.ASG_ANNOTATION__BOUND_OBJECTS);
                linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(node.getName()));
                linkVariable.setBindingOperator(BindingOperator.CREATE);
                continue;
            }
            if (!hasSetFragments || !SpecificationUtil.isInSet((PSNode)node)) continue;
            var = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            var.setBindingState(BindingState.BOUND);
            linkVariable = StorydrivenUtil.addLinkVariable(storyNode, this.createdAnnotationVariable, var, AnnotationsPackage.Literals.ASG_ANNOTATION__BOUND_OBJECTS);
            linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(node.getName()));
            linkVariable.setBindingOperator(BindingOperator.CREATE);
        }
        return storyNode;
    }

    private ActivityNode createPrepareSetFragmentFinding() {
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Prepare Set Fragments Finding");
        String name = this.createdAnnotationVariable.getName();
        EClass classifier = this.generator.getAnnotationClass(this.pattern);
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        annotationVar.setBindingState(BindingState.BOUND);
        name = StorydrivenUtil.getValidName(this.pattern, "setsValid");
        this.createdSetResultCheckVariable = StorydrivenUtil.addPrimitiveVariable(storyNode, name, EcorePackage.Literals.EBOOLEAN);
        return storyNode;
    }

    private ActivityNode createFindSetFragments() {
        Activity callable = this.generator.getActivity(this.pattern, "findSetFragments");
        ActivityCallNode callNode = StorydrivenUtil.addActivityCallNode(this.activity, (Callable)callable);
        EParameter operationParameter = StorydrivenUtil.getEParameter(callable, "this");
        EParameter callableParameter = StorydrivenUtil.getEParameter(this.activity, "this");
        StorydrivenUtil.createParameterBindingForwarding(operationParameter, callableParameter, (Invocation)callNode);
        operationParameter = StorydrivenUtil.getEParameter(callable, "annotation");
        StorydrivenUtil.createParameterBinding(operationParameter, this.createdAnnotationVariable, (Invocation)callNode);
        for (EParameter out : callable.getOwningOperation().getOutParameters()) {
            StorydrivenUtil.createParameterBinding(out, this.createdSetResultCheckVariable, (Invocation)callNode);
        }
        return callNode;
    }

    private ActivityNode createCheckSetFragmentResults() {
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Check Set Fragment Results");
        StorydrivenUtil.addSetResultsExpression(this.pattern, storyNode);
        return storyNode;
    }

    private ActivityNode createCheckForExistingAnnotation() {
        PSAnnotation createAnnotation = SpecificationUtil.getCreateAnnotation((PSPatternSpecification)this.pattern);
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Check For Existing Annotation");
        String name = StorydrivenUtil.getValidName(this.pattern, "any");
        EClass classifier = this.generator.getAnnotationClass(this.pattern);
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        for (PSNode node : SpecificationUtil.getAnnotatedElements((PSPatternSpecification)this.pattern)) {
            if (!SpecificationUtil.isNormal((PSNode)node) && !SpecificationUtil.isInSet((PSNode)node)) continue;
            name = node.getName();
            classifier = null;
            if (node instanceof PSAnnotation) {
                classifier = this.generator.getAnnotationClass(((PSAnnotation)node).getType());
            } else if (node instanceof PSObject) {
                classifier = ((PSObject)node).getInstanceOf();
            }
            ObjectVariable variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            variable.setBindingState(BindingState.BOUND);
            String qualifier = null;
            for (PSConnection in : node.getIncoming()) {
                if (!createAnnotation.equals(in.getSource()) || !(in instanceof PSLink)) continue;
                qualifier = ((PSLink)in).getQualifier();
            }
            LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(storyNode, annotationVar, variable, AnnotationsPackage.Literals.ASG_ANNOTATION__ANNOTATED_ELEMENTS);
            linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(qualifier));
        }
        return storyNode;
    }

    private ActivityNode createAddAnnotation() {
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Add Annotation To Results");
        storyNode.setForEach(true);
        String name = "this";
        EClass classifier = this.generator.getEngineClass(this.pattern);
        ObjectVariable thisVariable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        thisVariable.setBindingState(BindingState.BOUND);
        name = StorydrivenUtil.getValidName(this.pattern, "annotationResultSet");
        classifier = AnnotationsPackage.Literals.ANNOTATION_SET;
        ObjectVariable resultVariable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        StorydrivenUtil.addLinkVariable(storyNode, thisVariable, resultVariable, AnnotationsPackage.Literals.ANNOTATION_ENGINE__FOUND_ANNOTATIONS);
        name = this.createdAnnotationVariable.getName();
        classifier = this.generator.getAnnotationClass(this.pattern);
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        annotationVar.setBindingState(BindingState.BOUND);
        LinkVariable annotationLinkVariable = StorydrivenUtil.addLinkVariable(storyNode, resultVariable, annotationVar, AnnotationsPackage.Literals.ANNOTATION_SET__ANNOTATIONS);
        annotationLinkVariable.setBindingOperator(BindingOperator.CREATE);
        for (PSNode node : SpecificationUtil.getAnnotatedElements((PSPatternSpecification)this.pattern)) {
            if (!SpecificationUtil.isNormal((PSNode)node) && !SpecificationUtil.isInSet((PSNode)node)) continue;
            name = StorydrivenUtil.getValidName(this.pattern, "bound_" + node.getName());
            classifier = EcorePackage.Literals.EOBJECT;
            ObjectVariable variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(storyNode, annotationVar, variable, AnnotationsPackage.Literals.ASG_ANNOTATION__BOUND_OBJECTS);
            linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(node.getName()));
        }
        StoryNode bindNode = this.createBindNode();
        StorydrivenUtil.addTransition((ActivityNode)storyNode, (ActivityNode)bindNode, EdgeGuard.EACH_TIME);
        StorydrivenUtil.addTransition((ActivityNode)bindNode, (ActivityNode)storyNode);
        return storyNode;
    }

    private StoryNode createBindNode() {
        PSAnnotation createAnnotation = SpecificationUtil.getCreateAnnotation((PSPatternSpecification)this.pattern);
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Annotate Elements");
        String name = this.createdAnnotationVariable.getName();
        EClass classifier = this.generator.getAnnotationClass(this.pattern);
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        annotationVar.setBindingState(BindingState.BOUND);
        for (PSNode node : SpecificationUtil.getAnnotatedElements((PSPatternSpecification)this.pattern)) {
            if (!SpecificationUtil.isNormal((PSNode)node) && !SpecificationUtil.isInSet((PSNode)node)) continue;
            name = StorydrivenUtil.getValidName(this.pattern, "bound_" + node.getName());
            classifier = EcorePackage.Literals.EOBJECT;
            ObjectVariable variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            variable.setBindingState(BindingState.BOUND);
            String qualifier = null;
            for (PSConnection in : node.getIncoming()) {
                if (!createAnnotation.equals(in.getSource()) || !(in instanceof PSLink)) continue;
                qualifier = ((PSLink)in).getQualifier();
            }
            LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(storyNode, annotationVar, variable, AnnotationsPackage.Literals.ASG_ANNOTATION__ANNOTATED_ELEMENTS);
            linkVariable.setQualifierExpression(ExpressionsUtil.createQualifierExpression(qualifier));
            linkVariable.setBindingOperator(BindingOperator.CREATE);
        }
        return storyNode;
    }

    private ActivityNode createStoreAntecedents() {
        PSAnnotation createAnnotation = SpecificationUtil.getCreateAnnotation((PSPatternSpecification)this.pattern);
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Store Antecedent Relations");
        String name = this.createdAnnotationVariable.getName();
        EClass classifier = this.generator.getAnnotationClass(this.pattern);
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        annotationVar.setBindingState(BindingState.BOUND);
        for (PSNode node : SpecificationUtil.getAnnotations((PSPatternSpecification)this.pattern)) {
            if (createAnnotation.equals(node) || !(node instanceof PSAnnotation) || !SpecificationUtil.isNormal((PSNode)node)) continue;
            name = node.getName();
            classifier = this.generator.getAnnotationClass(((PSAnnotation)node).getType());
            ObjectVariable variable = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
            variable.setBindingState(BindingState.BOUND);
            LinkVariable linkVariable = StorydrivenUtil.addLinkVariable(storyNode, annotationVar, variable, AnnotationsPackage.Literals.ASG_ANNOTATION__ANTECEDENT_ANNOS);
            linkVariable.setBindingOperator(BindingOperator.CREATE);
        }
        return storyNode;
    }

    private ActivityNode createDestroyInvalidAnnotation() {
        StoryNode storyNode = StorydrivenUtil.addStoryNode(this.activity, "Destroy Invalid Annotation");
        String name = this.createdAnnotationVariable.getName();
        EClass classifier = this.generator.getAnnotationClass(this.pattern);
        ObjectVariable annotationVar = StorydrivenUtil.addObjectVariable(storyNode, name, classifier);
        annotationVar.setBindingOperator(BindingOperator.DESTROY);
        return storyNode;
    }

    private ActivityNode createFindAdditionalElements() {
        Activity callable = this.generator.getActivity(this.pattern, "findAdditionalElements");
        ActivityCallNode callNode = StorydrivenUtil.addActivityCallNode(this.activity, (Callable)callable);
        EParameter operationParameter = StorydrivenUtil.getEParameter(callable, "this");
        EParameter callableParameter = StorydrivenUtil.getEParameter(this.activity, "this");
        StorydrivenUtil.createParameterBindingForwarding(operationParameter, callableParameter, (Invocation)callNode);
        operationParameter = StorydrivenUtil.getEParameter(callable, "annotation");
        StorydrivenUtil.createParameterBinding(operationParameter, this.createdAnnotationVariable, (Invocation)callNode);
        return callNode;
    }
}

