/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.preparationstrategies;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.reclipse.structure.generator.preparationstrategies.AbstractEnginePreparationStrategy;

public class LoadExistingEnginesStrategy
extends AbstractEnginePreparationStrategy {
    public LoadExistingEnginesStrategy(Resource catalogResource, Resource enginesResource) {
        super(catalogResource);
        this.enginesResource = enginesResource;
    }

    @Override
    public IStatus prepareEngines() {
        try {
            this.loadCatalog();
        }
        catch (IOException e) {
            return this.reporter.error("Pattern catalog could not be loaded: " + e.getMessage(), new Object[0]);
        }
        try {
            this.loadEnginesResource();
        }
        catch (IOException e) {
            return this.reporter.error("The input resource could not be loaded: " + e.getLocalizedMessage(), new Object[0]);
        }
        return Status.OK_STATUS;
    }

    private void loadEnginesResource() throws IOException {
        this.reporter.task("Loading annotations and engines", new Object[0]);
        this.enginesResource.load(this.catalogResource.getResourceSet().getLoadOptions());
        this.reporter.debug("Annotations and engines input resource loaded.", new Object[0]);
    }
}

