/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.preparationstrategies;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.fujaba.commons.console.IReportListener;
import org.reclipse.structure.generator.Generator;
import org.reclipse.structure.generator.preparationstrategies.AbstractEnginePreparationStrategy;
import org.reclipse.structure.specification.PSCatalog;

public class GenerateNewEnginesStrategy
extends AbstractEnginePreparationStrategy {
    public GenerateNewEnginesStrategy(Resource catalogResource) {
        super(catalogResource);
    }

    @Override
    public IStatus prepareEngines() {
        PSCatalog catalog;
        try {
            catalog = this.loadCatalog();
        }
        catch (IOException e) {
            return this.reporter.error("Pattern catalog could not be loaded: " + e.getMessage(), new Object[0]);
        }
        try {
            this.createAndLoadEnginesResource();
        }
        catch (IOException io) {
            return this.reporter.error("Could not create engines resource: " + io.getLocalizedMessage(), new Object[0]);
        }
        if (this.enginesResource == null || !this.enginesResource.isLoaded()) {
            return this.reporter.error("Engines resource could not be loaded!", new Object[0]);
        }
        this.generateEngines(catalog);
        try {
            this.saveGeneratedEngines();
        }
        catch (IOException e) {
            return this.reporter.error("Could not save engines resource:" + e.getLocalizedMessage(), new Object[0]);
        }
        return Status.OK_STATUS;
    }

    protected void generateEngines(PSCatalog catalog) {
        HashSet<EObject> contents = new HashSet<EObject>();
        Generator generator = new Generator((IReportListener)this.reporter);
        generator.generate(contents, catalog);
        this.enginesResource.getContents().addAll(contents);
    }

    protected void saveGeneratedEngines() throws IOException {
        this.reporter.task("Saving generated engines resource", new Object[0]);
        this.enginesResource.save(Collections.emptyMap());
        this.reporter.debug("Engines resource has been saved.", new Object[0]);
    }

    protected void createAndLoadEnginesResource() throws IOException {
        URI enginesResourceURI = this.catalogResource.getURI().appendFileExtension("ecore");
        this.enginesResource = null;
        this.reporter.task("Preparing engines resource", new Object[0]);
        try {
            this.enginesResource = this.catalogResource.getResourceSet().getResource(enginesResourceURI, true);
            this.enginesResource.getContents().clear();
            this.reporter.debug("Existing engines resource found, it will be overwritten.", new Object[0]);
        }
        catch (WrappedException e) {
            this.reporter.debug("Creating new engines resource...", new Object[0]);
        }
        if (this.enginesResource == null) {
            this.enginesResource = this.catalogResource.getResourceSet().createResource(enginesResourceURI);
            this.enginesResource.save(Collections.emptyMap());
            this.enginesResource.load(this.catalogResource.getResourceSet().getLoadOptions());
            this.reporter.debug("New engines resource has been created.", new Object[0]);
        }
    }
}

