/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator.preparationstrategies;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.fujaba.commons.console.IControllableReportListener;
import org.reclipse.structure.specification.PSCatalog;

public abstract class AbstractEnginePreparationStrategy {
    protected Resource catalogResource;
    protected Resource enginesResource;
    protected IControllableReportListener reporter;
    protected String catalogPath;

    public AbstractEnginePreparationStrategy(Resource catalogResource) {
        this.catalogResource = catalogResource;
    }

    public abstract IStatus prepareEngines();

    protected PSCatalog loadCatalog() throws IOException {
        PSCatalog catalog = null;
        this.reporter.task("Loading catalog input resource", new Object[0]);
        this.catalogResource.load(this.catalogResource.getResourceSet().getLoadOptions());
        this.reporter.debug("Catalog input resource loaded.", new Object[0]);
        for (EObject content : this.catalogResource.getContents()) {
            if (!(content instanceof PSCatalog)) continue;
            catalog = (PSCatalog)content;
            return catalog;
        }
        return catalog;
    }

    public IControllableReportListener getReporter() {
        return this.reporter;
    }

    public void setReporter(IControllableReportListener reporter) {
        this.reporter = reporter;
    }
}

