/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.fujaba.commons.console.IReportListener;
import org.reclipse.structure.generator.steps.AnnotateStep;
import org.reclipse.structure.generator.steps.FindAdditionalElementsStep;
import org.reclipse.structure.generator.steps.FindSetFragmentsStep;
import org.reclipse.structure.generator.util.Constants;
import org.reclipse.structure.generator.util.EcoreUtil;
import org.reclipse.structure.generator.util.IGenerator;
import org.reclipse.structure.generator.util.NameUtil;
import org.reclipse.structure.inference.annotations.AnnotationsPackage;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSCombinedFragment;
import org.reclipse.structure.specification.PSCombinedFragmentItem;
import org.reclipse.structure.specification.PSMetricConstraint;
import org.reclipse.structure.specification.PSNode;
import org.reclipse.structure.specification.PSNodeConstraint;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.SpecificationFactory;
import org.reclipse.structure.specification.util.SpecificationUtil;
import org.reclipse.structure.specification.util.TriggerManager;
import org.storydriven.storydiagrams.activities.ActivitiesFactory;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.OperationExtension;

public class Generator
implements IGenerator,
Constants {
    private final IReportListener reporter;
    private final Map<PSPatternSpecification, EClass> annotations;
    private final Map<PSPatternSpecification, EClass> engines;
    private final Map<PSPatternSpecification, Map<String, Activity>> activities;
    private final AnnotateStep annotateGenerator;
    private final FindSetFragmentsStep setsGenerator;
    private final FindAdditionalElementsStep additionalsGenerator;
    private TriggerManager triggerManager;

    public Generator(IReportListener reporter) {
        this.reporter = reporter;
        this.annotateGenerator = new AnnotateStep(this);
        this.setsGenerator = new FindSetFragmentsStep(this);
        this.additionalsGenerator = new FindAdditionalElementsStep(this);
        this.annotations = new HashMap<PSPatternSpecification, EClass>();
        this.engines = new HashMap<PSPatternSpecification, EClass>();
        this.activities = new HashMap<PSPatternSpecification, Map<String, Activity>>();
    }

    public void generate(Collection<EObject> container, PSCatalog catalog) {
        EPackage annotationPackage = this.createAnnotationsPackage(container);
        this.createAnnotationClasses(catalog, annotationPackage);
        this.triggerManager = new TriggerManager((IReportListener)this, (Collection)catalog.getPatternSpecifications());
        EPackage enginesPackage = this.createEnginesPackage(container);
        this.createEngineClasses(catalog, enginesPackage);
    }

    private void createEngineClasses(PSCatalog catalog, EPackage enginesPackage) {
        for (PSPatternSpecification pattern : catalog.getPatternSpecifications()) {
            if (pattern.isAbstract()) continue;
            this.workaroundSets(pattern);
            this.workaroundNegatives(pattern);
            this.addEngineClass(enginesPackage, pattern);
            this.revertWorkaroundSets(pattern);
            this.revertWorkaroundNegatives(pattern);
        }
    }

    private EPackage createEnginesPackage(Collection<EObject> container) {
        this.debug("Creating package '%1s'...", "engines");
        EPackage enginesPackage = EcoreUtil.addEPackage(container, "engines", "http://ns.reclipse.org/structure/generation/engines");
        return enginesPackage;
    }

    private void createAnnotationClasses(PSCatalog catalog, EPackage annotationPackage) {
        for (PSPatternSpecification pattern : catalog.getPatternSpecifications()) {
            this.addAnnotationClass(annotationPackage, pattern);
        }
    }

    private EPackage createAnnotationsPackage(Collection<EObject> container) {
        this.debug("Creating package '%1s'...", "annotations");
        EPackage annotationPackage = EcoreUtil.addEPackage(container, "annotations", "http://ns.reclipse.org/structure/generation/annotations");
        return annotationPackage;
    }

    private EClass addAnnotationClass(EPackage container, PSPatternSpecification pattern) {
        if (this.annotations.containsKey(pattern)) {
            return this.annotations.get(pattern);
        }
        String name = String.valueOf(pattern.getName()) + "Annotation";
        this.debug("Creating class '%1s'...", name);
        EClass element = EcoreUtil.addEClass(container, name);
        this.annotations.put(pattern, element);
        EClass superType = AnnotationsPackage.Literals.ASG_ANNOTATION;
        if (pattern.getSuperPattern() != null) {
            superType = this.addAnnotationClass(container, pattern.getSuperPattern());
        }
        element.getESuperTypes().add((Object)superType);
        return element;
    }

    private void addEngineClass(EPackage container, PSPatternSpecification pattern) {
        String name = String.valueOf(pattern.getName()) + "Engine";
        this.debug("Creating class '%1s'...", String.valueOf(pattern.getName()) + "Engine");
        EClass engineClass = EcoreUtil.addEClass(container, name);
        this.engines.put(pattern, engineClass);
        engineClass.getESuperTypes().add((Object)AnnotationsPackage.Literals.ANNOTATION_ENGINE);
        if (this.setsContainedIn(pattern)) {
            Activity findSetFragements = this.createFindSets(engineClass, pattern);
            this.setsGenerator.generate(findSetFragements, pattern);
        }
        if (SpecificationUtil.isAdditionalElements((PSPatternSpecification)pattern)) {
            Activity findAdditionalElements = this.createFindAdditionals(engineClass, pattern);
            this.additionalsGenerator.generate(findAdditionalElements, pattern);
        }
        Activity annotate = this.createAnnotate(engineClass, pattern);
        this.annotateGenerator.generate(annotate, pattern);
    }

    private boolean setsContainedIn(PSPatternSpecification pattern) {
        return SpecificationUtil.isSetSearchRequired((PSPatternSpecification)pattern);
    }

    private void workaroundSets(PSPatternSpecification pattern) {
        for (PSNode node : pattern.getNodes()) {
            if (!ModifierType.SET.equals((Object)node.getModifier())) continue;
            node.setModifier(ModifierType.NONE);
            PSCombinedFragment wrapper = SpecificationFactory.eINSTANCE.createPSCombinedFragment();
            wrapper.setKind(ModifierType.SET);
            wrapper.setName(String.valueOf(node.getName()) + "Wrapper");
            wrapper.setWeight(node.getWeight());
            wrapper.setPatternSpecification(pattern);
            wrapper.getChildren().add((Object)node);
            PSNodeConstraint constraint = null;
            for (PSNodeConstraint nodeConstraint : node.getNodeConstraints()) {
                if (constraint != null) {
                    this.warn("Could not wrap set node '%1s' with a fragment: Found more than one SIZE constraint!", node.getName());
                }
                if (!(nodeConstraint instanceof PSMetricConstraint) || !"SIZE".equals(((PSMetricConstraint)nodeConstraint).getMetricAcronym())) continue;
                constraint = nodeConstraint;
            }
            node.getNodeConstraints().remove(constraint);
            wrapper.setConstraint(constraint);
        }
    }

    private void workaroundNegatives(PSPatternSpecification pattern) {
        for (PSNode node : pattern.getNodes()) {
            if (!ModifierType.NEGATIVE.equals((Object)node.getModifier())) continue;
            node.setModifier(ModifierType.NONE);
            PSCombinedFragment wrapper = SpecificationFactory.eINSTANCE.createPSCombinedFragment();
            wrapper.setKind(ModifierType.NEGATIVE);
            wrapper.setName(String.valueOf(node.getName()) + "Wrapper");
            wrapper.setWeight(node.getWeight());
            wrapper.getChildren().add((Object)node);
            PSNodeConstraint constraint = null;
            for (PSNodeConstraint nodeConstraint : node.getNodeConstraints()) {
                if (constraint != null) {
                    this.warn("Could not wrap negative node '%1s' with a fragment: Found more than one SIZE constraint!", node.getName());
                }
                if (!(nodeConstraint instanceof PSMetricConstraint) || !"SIZE".equals(((PSMetricConstraint)nodeConstraint).getMetricAcronym())) continue;
                constraint = nodeConstraint;
            }
            node.getNodeConstraints().remove(constraint);
            wrapper.setConstraint(constraint);
            wrapper.setPatternSpecification(pattern);
        }
    }

    private Activity createFindSets(EClass engineClass, PSPatternSpecification pattern) {
        EOperation operation = EcoreUtil.addEOperation(engineClass, "findSetFragments");
        operation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        EcoreUtil.addEParameter(operation, "this", (EClassifier)engineClass);
        EcoreUtil.addEParameter(operation, "annotation", (EClassifier)AnnotationsPackage.Literals.ASG_ANNOTATION);
        return this.createActivity(operation, pattern);
    }

    private Activity createFindAdditionals(EClass engineClass, PSPatternSpecification pattern) {
        EOperation operation = EcoreUtil.addEOperation(engineClass, "findAdditionalElements");
        EcoreUtil.addEParameter(operation, "this", (EClassifier)engineClass);
        EcoreUtil.addEParameter(operation, "annotation", (EClassifier)AnnotationsPackage.Literals.ASG_ANNOTATION);
        return this.createActivity(operation, pattern);
    }

    private Activity createAnnotate(EClass engineClass, PSPatternSpecification pattern) {
        EOperation operation = EcoreUtil.addEOperation(engineClass, "annotate");
        operation.setEType((EClassifier)AnnotationsPackage.Literals.ANNOTATION_SET);
        EcoreUtil.addEParameter(operation, "this", (EClassifier)engineClass);
        EcoreUtil.addEParameter(operation, "element", (EClassifier)EcorePackage.Literals.EOBJECT);
        EcoreUtil.addEParameter(operation, "searchForOptionalElements", (EClassifier)EcorePackage.Literals.EBOOLEAN);
        return this.createActivity(operation, pattern);
    }

    @Override
    public Activity createActivity(EOperation operation, PSPatternSpecification pattern) {
        Activity activity = ActivitiesFactory.eINSTANCE.createActivity();
        activity.setName(NameUtil.getName(operation));
        activity.setComment(NameUtil.getName(operation));
        OperationExtension extension = ActivitiesFactory.eINSTANCE.createOperationExtension();
        extension.setOwnedActivity(activity);
        extension.setOperation(operation);
        activity.getInParameters().addAll((Collection)operation.getEParameters());
        assert (extension.getOutParameters().size() <= 1) : "Activities should only have one out parameter.";
        Map<String, Activity> cachedActivities = this.activities.get(pattern);
        if (cachedActivities == null) {
            cachedActivities = new HashMap<String, Activity>();
            this.activities.put(pattern, cachedActivities);
        }
        cachedActivities.put(operation.getName(), activity);
        return activity;
    }

    private void revertWorkaroundSets(PSPatternSpecification pattern) {
        ArrayList<PSCombinedFragment> toRemove = new ArrayList<PSCombinedFragment>();
        for (PSCombinedFragment fragment : pattern.getCombinedFragments()) {
            if (!ModifierType.SET.equals((Object)fragment.getKind()) || !fragment.getName().endsWith("Wrapper") || fragment.getChildren().size() != 1) continue;
            for (PSCombinedFragmentItem item : fragment.getChildren()) {
                if (!(item instanceof PSNode) || !ModifierType.NONE.equals((Object)((PSNode)item).getModifier())) continue;
                PSNode node = (PSNode)item;
                node.setModifier(ModifierType.SET);
                node.setWeight(fragment.getWeight());
                PSNodeConstraint constraint = fragment.getConstraint();
                if (constraint == null) continue;
                fragment.setConstraint(null);
                node.getNodeConstraints().add((Object)constraint);
            }
            toRemove.add(fragment);
        }
        pattern.getCombinedFragments().removeAll(toRemove);
    }

    private void revertWorkaroundNegatives(PSPatternSpecification pattern) {
        ArrayList<PSCombinedFragment> toRemove = new ArrayList<PSCombinedFragment>();
        for (PSCombinedFragment fragment : pattern.getCombinedFragments()) {
            if (!ModifierType.NEGATIVE.equals((Object)fragment.getKind()) || !fragment.getName().endsWith("Wrapper") || fragment.getChildren().size() != 1) continue;
            for (PSCombinedFragmentItem item : fragment.getChildren()) {
                if (!(item instanceof PSNode) || !ModifierType.NONE.equals((Object)((PSNode)item).getModifier())) continue;
                PSNode node = (PSNode)item;
                node.setModifier(ModifierType.NEGATIVE);
                node.setWeight(fragment.getWeight());
                PSNodeConstraint constraint = fragment.getConstraint();
                if (constraint == null) continue;
                fragment.setConstraint(null);
                node.getNodeConstraints().add((Object)constraint);
            }
            toRemove.add(fragment);
        }
        pattern.getCombinedFragments().removeAll(toRemove);
    }

    @Override
    public EClass getAnnotationClass(PSPatternSpecification pattern) {
        return this.annotations.get(pattern);
    }

    @Override
    public EClass getEngineClass(PSPatternSpecification pattern) {
        return this.engines.get(pattern);
    }

    @Override
    public Activity getActivity(PSPatternSpecification pattern, String name) {
        Map<String, Activity> cached = this.activities.get(pattern);
        if (cached != null) {
            return cached.get(name);
        }
        return null;
    }

    @Override
    public PSNode getTrigger(PSPatternSpecification pattern) {
        return this.triggerManager.getTrigger(pattern);
    }

    public IStatus error(String message, Object ... args) {
        return this.reporter.error(message, args);
    }

    public void warn(String message, Object ... args) {
        this.reporter.warn(message, args);
    }

    public void append(String message, Object ... args) {
        this.reporter.append(message, args);
    }

    public void task(String message, Object ... args) {
        this.reporter.task(message, args);
    }

    public void info(String message, Object ... args) {
        this.reporter.info(message, args);
    }

    public void debug(String message, Object ... args) {
        this.reporter.debug(message, args);
    }
}

