/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.patterns.structure.generator.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.fujaba.commons.console.ReportLevel;
import org.fujaba.commons.ui.WorkbenchFileTreeSelectionDialog;

public class ExportPatternsWizardPage
extends WizardPage {
    private final WorkbenchFileTreeSelectionDialog dialog;
    private String inputPath;
    private String outputContainer;
    private String outputName;
    protected ReportLevel reportLevel;
    private Combo reportCombo;

    protected ExportPatternsWizardPage() {
        super(ExportPatternsWizardPage.class.getSimpleName());
        this.setTitle("Generate Pattern Detection Engines");
        this.setDescription("Select the location to which the pattern detection engines should be exported.");
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        String title = "Select Catalog";
        String message = "Select the catalog file which should be exported.";
        this.dialog = new WorkbenchFileTreeSelectionDialog(shell, title, message, "psc");
    }

    public void createControl(Composite parent) {
        if (this.inputPath == null || this.outputContainer == null || this.outputName == null || this.reportLevel == null) {
            this.inputPath = this.getDialogSettings().get("input_path");
            this.inputPath = this.inputPath == null ? "" : this.inputPath;
            this.outputContainer = this.getDialogSettings().get("output_container");
            this.outputContainer = this.outputContainer == null ? "" : this.outputContainer;
            this.outputName = this.getDialogSettings().get("output_name");
            this.outputName = this.outputName == null ? "" : this.outputName;
            this.reportLevel = ReportLevel.getItem((String)this.getDialogSettings().get("report_level"));
        }
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(main);
        main.setLayout((Layout)new GridLayout(1, false));
        Composite input = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)input);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(input);
        Label inputLabel = new Label(input, 131072);
        final Text inputText = new Text(input, 18436);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputText);
        Button inputButton = new Button(input, 8);
        GridDataFactory.fillDefaults().applyTo((Control)inputButton);
        Group output = new Group(main, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo((Composite)output);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)output);
        final TreeViewer outputContainerViewer = new TreeViewer((Composite)output, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outputContainerViewer.getTree());
        outputContainerViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        outputContainerViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        outputContainerViewer.setComparator(new ViewerComparator());
        outputContainerViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IContainer) {
                    return ((IContainer)element).getName().charAt(0) != '.';
                }
                return false;
            }
        });
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        outputContainerViewer.setInput((Object)root);
        Composite outputFile = new Composite((Composite)output, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outputFile);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(outputFile);
        Label outputFileLabel = new Label(outputFile, 131072);
        final Text outputFileText = new Text(outputFile, 18436);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outputFileText);
        inputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportPatternsWizardPage.this.inputPath = inputText.getText();
                ExportPatternsWizardPage.this.setPageComplete(ExportPatternsWizardPage.this.isValid());
            }
        });
        inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected;
                if (ExportPatternsWizardPage.this.dialog.open() == 0 && (selected = ExportPatternsWizardPage.this.dialog.getFirstResult()) instanceof IFile) {
                    inputText.setText(((IFile)selected).getFullPath().toString());
                }
            }
        });
        outputContainerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!outputContainerViewer.getSelection().isEmpty()) {
                    Object selected = ((IStructuredSelection)outputContainerViewer.getSelection()).getFirstElement();
                    if (selected instanceof IContainer) {
                        ExportPatternsWizardPage.this.outputContainer = ((IContainer)selected).getFullPath().toString();
                    } else {
                        ExportPatternsWizardPage.this.outputContainer = null;
                    }
                    ExportPatternsWizardPage.this.setPageComplete(ExportPatternsWizardPage.this.isValid());
                }
            }
        });
        outputFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportPatternsWizardPage.this.outputName = outputFileText.getText();
                ExportPatternsWizardPage.this.setPageComplete(ExportPatternsWizardPage.this.isValid());
            }
        });
        inputLabel.setText("Catalog:");
        inputButton.setText("Select");
        output.setText("Output");
        outputFileLabel.setText("File Name:");
        inputText.setText(this.inputPath);
        outputFileText.setText(this.outputName);
        IResource container = root.findMember(this.inputPath);
        if (container instanceof IFile) {
            outputContainerViewer.setSelection((ISelection)new StructuredSelection((Object)container.getParent()));
        }
        this.setControl((Control)main);
        Composite reportComposite = new Composite(main, 0);
        reportComposite.setLayout((Layout)new GridLayout(2, false));
        Label reportLabel = new Label(reportComposite, 0);
        reportLabel.setText("Report Level:");
        this.reportCombo = new Combo(reportComposite, 12);
        this.reportCombo.setItems(ReportLevel.getItems());
        this.reportCombo.select(ReportLevel.getIndex((ReportLevel)this.reportLevel));
        this.reportCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportPatternsWizardPage.this.reportLevel = ReportLevel.getItem((int)ExportPatternsWizardPage.this.reportCombo.getSelectionIndex());
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                Object selected = objectArray[n2];
                if (selected instanceof IFile && "psc".equalsIgnoreCase((file = (IFile)selected).getFileExtension())) {
                    this.inputPath = file.getFullPath().toString();
                    this.outputContainer = file.getParent().getFullPath().toString();
                    this.outputName = file.getFullPath().addFileExtension("ecore").toString();
                    this.reportLevel = ReportLevel.INFO;
                    break;
                }
                ++n2;
            }
        }
    }

    public void saveSettings() {
        this.getDialogSettings().put("input_path", this.inputPath);
        this.getDialogSettings().put("output_container", this.outputContainer);
        this.getDialogSettings().put("output_name", this.outputName);
        this.getDialogSettings().put("report_level", ReportLevel.getIndex((ReportLevel)this.reportLevel));
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return String.valueOf(this.outputContainer) + '/' + this.outputName;
    }

    public ReportLevel getReportLevel() {
        return this.reportLevel;
    }

    protected boolean isValid() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (this.inputPath == null || !(root.findMember(this.inputPath) instanceof IFile)) {
            this.setErrorMessage("Select a valid input resource!");
            return false;
        }
        this.dialog.setInitialSelection((Object)root.findMember(this.inputPath));
        if (this.outputContainer == null || !(root.findMember(this.outputContainer) instanceof IContainer)) {
            this.setErrorMessage("Select a valid output container!");
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }
}

