/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.metrics.extensionpoints;

import java.io.InvalidClassException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.reclipse.metrics.MetricsPlugin;
import org.reclipse.metrics.extensionpoints.IMetricCalculator;
import org.reclipse.metrics.extensionpoints.Metric;
import org.reclipse.metrics.extensionpoints.MetricCalculator;

public class MetricUtil {
    private static final String EPID_METRICS = "org.reclipse.metrics.metrics";
    private static final String EPID_CALCULATORS = "org.reclipse.metrics.calculators";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ACRONYM = "acronym";
    private static final String DESC = "description";
    private static final String METAMODEL = "metamodel_id";
    private static final String METRIC = "metric_id";
    private static final String CLASS = "class";
    private static Set<Metric> metrics;
    private static Set<MetricCalculator> metricCalculators;

    private MetricUtil() {
    }

    public static Set<Metric> getAllMetrics() {
        if (metrics == null) {
            metrics = new HashSet<Metric>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EPID_METRICS);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Metric metric;
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String id = ce.getAttribute(ID);
                String name = ce.getAttribute(NAME);
                String acronym = ce.getAttribute(ACRONYM);
                String desc = null;
                IConfigurationElement[] descContainer = ce.getChildren(DESC);
                if (descContainer.length == 1) {
                    desc = descContainer[0].getValue();
                }
                if (metrics.contains(metric = new Metric(id, acronym, name, desc))) {
                    MetricsPlugin.getInstance().logWarning("Two metrics with the same ID wanted to be registered: duplicate ignored.");
                } else {
                    metrics.add(metric);
                }
                ++n2;
            }
            if (metrics.isEmpty()) {
                MetricsPlugin.getInstance().logInfo("No metrics registered.");
            }
        }
        return metrics;
    }

    public static Set<MetricCalculator> getAllCalculators() {
        if (metricCalculators == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EPID_CALCULATORS);
            if (point == null || MetricUtil.getAllMetrics().isEmpty()) {
                MetricsPlugin.getInstance().logInfo("No metric calculators registered.");
                metricCalculators = Collections.emptySet();
                return metricCalculators;
            }
            metricCalculators = new HashSet<MetricCalculator>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EPID_CALCULATORS);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    String id = ce.getAttribute(ID);
                    String metricId = ce.getAttribute(METRIC);
                    String metamodel = ce.getAttribute(METAMODEL);
                    Object calculator = ce.createExecutableExtension(CLASS);
                    if (!(calculator instanceof IMetricCalculator)) {
                        throw new InvalidClassException("The class has to implement IMetricCalculator.");
                    }
                    MetricCalculator calc = new MetricCalculator(id, metamodel, MetricUtil.getMetric(metricId), (IMetricCalculator)calculator);
                    if (metricCalculators.contains(calc)) {
                        MetricsPlugin.getInstance().logInfo("Two metric calculators with the same ID wanted to be registered: duplicate ignored.");
                    } else {
                        metricCalculators.add(calc);
                    }
                }
                catch (Exception e) {
                    MetricsPlugin.getInstance().logError("Error reading registered metrics calculators", e);
                }
                ++n2;
            }
        }
        return metricCalculators;
    }

    public static Set<Metric> getMetricsFor(EClass type) {
        HashSet<Metric> result = new HashSet<Metric>();
        for (MetricCalculator c : MetricUtil.getAllCalculators()) {
            if (!c.getCalculator().isApplicableTo(type)) continue;
            result.add(c.getMetric());
        }
        return result;
    }

    public static Metric getMetric(String id) {
        for (Metric m : MetricUtil.getAllMetrics()) {
            if (!m.getId().equals(id)) continue;
            return m;
        }
        return null;
    }

    public static Metric getMetricByAcronym(String acronym) {
        for (Metric m : MetricUtil.getAllMetrics()) {
            if (!m.getAcronym().equals(acronym)) continue;
            return m;
        }
        return null;
    }

    public static double getMetricValue(EObject object, String acronym) {
        if (object != null) {
            for (MetricCalculator calc : MetricUtil.getAllCalculators()) {
                if (!acronym.equals(calc.getMetric().getAcronym()) || !calc.getCalculator().isApplicableTo(object.eClass())) continue;
                return calc.getCalculator().calculate(object);
            }
        }
        return 0.0;
    }
}

