/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.math.functions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.reclipse.math.functions.FunctionParameter;

public abstract class MathematicalFunction {
    private String name;
    private HashMap<String, FunctionParameter> params = new HashMap();
    public static String PROPERTY_PARAMS = "params";

    public String getName() {
        return this.name;
    }

    public abstract double value(double var1);

    public boolean addToParams(Map.Entry<String, FunctionParameter> entry) {
        return this.addToParams(entry.getKey(), entry.getValue());
    }

    public boolean addToParams(String key, FunctionParameter value) {
        boolean changed = false;
        if (key != null) {
            FunctionParameter oldValue;
            if (this.params == null) {
                this.params = new HashMap();
            }
            if ((oldValue = this.params.put(key, value)) != value) {
                if (oldValue != null) {
                    oldValue.setFunction(null, null);
                }
                if (value != null) {
                    value.setFunction(key, this);
                }
                changed = true;
            }
        }
        return changed;
    }

    public Iterator<Map.Entry<String, FunctionParameter>> entriesOfParams() {
        return this.params.entrySet().iterator();
    }

    public FunctionParameter getFromParams(String key) {
        return key == null ? null : this.params.get(key);
    }

    public boolean hasInParams(String key, FunctionParameter value) {
        return (value != null || this.params.containsKey(key)) && key != null && this.params.get(key) == value;
    }

    public boolean hasInParams(FunctionParameter value) {
        return this.params.containsValue(value);
    }

    public boolean hasKeyInParams(String key) {
        return key != null && this.params.containsKey(key);
    }

    public Iterator<? extends Object> iteratorOfParams() {
        return this.params.values().iterator();
    }

    public Iterator<? extends Object> keysOfParams() {
        return this.params.keySet().iterator();
    }

    public void removeAllFromParams() {
        Iterator<Map.Entry<String, FunctionParameter>> iter = this.entriesOfParams();
        while (iter.hasNext()) {
            Map.Entry<String, FunctionParameter> entry = iter.next();
            this.removeFromParams(entry.getKey(), entry.getValue());
        }
    }

    public boolean removeFromParams(String key, FunctionParameter value) {
        FunctionParameter oldValue;
        boolean changed = false;
        if (this.params != null && key != null && (oldValue = this.params.get(key)) == value && (oldValue != null || this.params.containsKey(key))) {
            this.params.remove(key);
            if (value != null) {
                value.setFunction(null, null);
            }
            changed = true;
        }
        return changed;
    }

    public boolean removeFromParams(FunctionParameter value) {
        boolean changed = false;
        if (this.params != null) {
            Iterator<Map.Entry<String, FunctionParameter>> iter = this.entriesOfParams();
            while (iter.hasNext()) {
                Map.Entry<String, FunctionParameter> entry = iter.next();
                if (entry.getValue() != value || !this.removeFromParams(entry.getKey(), value)) continue;
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeKeyFromParams(String key) {
        FunctionParameter tmpValue;
        boolean changed = false;
        if (this.params != null && key != null && (changed = this.params.containsKey(key)) && (tmpValue = this.params.remove(key)) != null) {
            tmpValue.setFunction(null, null);
        }
        return changed;
    }

    public int sizeOfParams() {
        return this.params == null ? 0 : this.params.size();
    }
}

