/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.math.functions;

import java.util.ArrayList;
import org.reclipse.math.functions.Lim0EFunction;
import org.reclipse.math.functions.Lim1EFunction;
import org.reclipse.math.functions.Lim1EFunctionNOA;
import org.reclipse.math.functions.Lim1EFunctionNOM;
import org.reclipse.math.functions.Lim1EFunctionWLOC;
import org.reclipse.math.functions.LinearFunction;
import org.reclipse.math.functions.MathematicalFunction;

public class MathFunctionsManager {
    private final ArrayList<Class<? extends MathematicalFunction>> allFunctions = new ArrayList();
    private final ArrayList<String> allFunctionsNames = new ArrayList();
    private static MathFunctionsManager instance;

    private MathFunctionsManager() {
        this.registerMathFunction(LinearFunction.getFunctionName(), LinearFunction.class);
        this.registerMathFunction(Lim0EFunction.getFunctionName(), Lim0EFunction.class);
        this.registerMathFunction(Lim1EFunction.getFunctionName(), Lim1EFunction.class);
        this.registerMathFunction(Lim1EFunctionNOA.getFunctionName(), Lim1EFunctionNOA.class);
        this.registerMathFunction(Lim1EFunctionNOM.getFunctionName(), Lim1EFunctionNOM.class);
        this.registerMathFunction(Lim1EFunctionWLOC.getFunctionName(), Lim1EFunctionWLOC.class);
    }

    public static MathFunctionsManager get() {
        if (instance == null) {
            instance = new MathFunctionsManager();
        }
        return instance;
    }

    public synchronized void registerMathFunction(String name, Class<? extends MathematicalFunction> function) {
        if (!this.allFunctions.contains(function)) {
            this.allFunctions.add(function);
            this.allFunctionsNames.add(name);
        }
    }

    public synchronized ArrayList<Class<? extends MathematicalFunction>> getAllKnownMathFunctions() {
        ArrayList<Class<? extends MathematicalFunction>> result = new ArrayList<Class<? extends MathematicalFunction>>(this.allFunctions);
        return result;
    }

    public synchronized ArrayList<String> getAllKnownMathFunctionsNames() {
        ArrayList<String> result = new ArrayList<String>(this.allFunctionsNames);
        return result;
    }
}

