/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.compilation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.reclipse.generator.compilation.JavaCompiler;
import org.reclipse.generator.compilation.PluginProjectCreationHelper;
import org.reclipse.generator.generation.AbstractGenerator;
import org.reclipse.generator.generation.FileInformation;
import org.reclipse.generator.generation.JavaFileInformation;

public class EclipseJavaCompiler
extends JavaCompiler {
    private static final String TMP_PROJECT_NAME = "org.reclipse.generator.temporaryproject";
    private IProject tmpProject;
    private IJavaProject tmpJavaProject;
    private IPackageFragmentRoot rootPackage;
    private IFolder binFolder;
    private HashSet<IPackageFragment> createdPackages = new HashSet();
    private boolean autoBuild = false;
    private boolean removeProject;
    private boolean debugInfo;
    private int codeComplianceLevel;
    private AbstractGenerator outputProvider;
    Collection<String> classPaths;
    Collection<String> pluginDependencies;

    public EclipseJavaCompiler(boolean removeProject, Collection<String> classPaths, Collection<String> pluginDependencies, boolean debugInfo, int codeComplianceLevel) {
        this.removeProject = removeProject;
        this.debugInfo = debugInfo;
        this.codeComplianceLevel = codeComplianceLevel;
        this.classPaths = classPaths;
        this.pluginDependencies = pluginDependencies;
    }

    private IPackageFragmentRoot getSourceFolder() throws CoreException {
        IFolder srcFolder = this.tmpProject.getFolder("src");
        IPackageFragmentRoot root = this.tmpJavaProject.getPackageFragmentRoot((IResource)srcFolder);
        return root;
    }

    private void createTemporaryProject() throws CoreException {
        this.deleteTemporaryProject();
        this.tmpProject = PluginProjectCreationHelper.createProject(TMP_PROJECT_NAME, this.pluginDependencies.toArray(new String[this.pluginDependencies.size()]), this.getCodeComplianceLevel());
        this.tmpJavaProject = JavaCore.create((IProject)this.tmpProject);
        this.binFolder = this.tmpProject.getFolder("bin");
        this.rootPackage = this.getSourceFolder();
        this.initClassPath();
    }

    private void initClassPath() throws JavaModelException, CoreException {
        IClasspathEntry[] newEntries = new IClasspathEntry[this.classPaths.size()];
        int i = 0;
        for (String tmpClasspath : this.classPaths) {
            if (tmpClasspath.endsWith(".jar") || tmpClasspath.endsWith(".zip")) {
                newEntries[i] = JavaCore.newLibraryEntry((IPath)new Path(tmpClasspath), null, null);
            } else {
                String name = tmpClasspath.replace(':', '_').replace(File.separatorChar, '_');
                IFolder folderLink = this.tmpProject.getFolder(name);
                folderLink.createLink((IPath)new Path(tmpClasspath), 16, null);
                newEntries[i] = JavaCore.newLibraryEntry((IPath)folderLink.getFullPath(), null, null);
            }
            ++i;
        }
        IClasspathEntry[] existing = this.tmpJavaProject.getRawClasspath();
        IClasspathEntry[] newClassPathEntries = new IClasspathEntry[existing.length + newEntries.length];
        int j = 0;
        while (j < newClassPathEntries.length) {
            newClassPathEntries[j] = j < existing.length ? existing[j] : newEntries[j - existing.length];
            ++j;
        }
        this.tmpJavaProject.setRawClasspath(newClassPathEntries, null);
    }

    private void deleteTemporaryProject() throws CoreException {
        if (this.tmpJavaProject != null) {
            this.tmpJavaProject.close();
            this.tmpJavaProject = null;
        }
        if (this.tmpProject != null) {
            this.tmpProject.close(null);
            this.tmpProject.delete(true, true, null);
            this.tmpProject = null;
        } else {
            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(TMP_PROJECT_NAME);
            if (prj.exists()) {
                prj.delete(true, true, null);
            }
        }
    }

    private void deactivateAutoBuilding() throws CoreException {
        IWorkspace wspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDescription = wspace.getDescription();
        this.autoBuild = wsDescription.isAutoBuilding();
        if (this.autoBuild) {
            wsDescription.setAutoBuilding(false);
            wspace.setDescription(wsDescription);
        }
    }

    private void restoreAutoBuilding() {
        IWorkspace wspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDescription = wspace.getDescription();
        if (this.autoBuild != wsDescription.isAutoBuilding()) {
            wsDescription.setAutoBuilding(this.autoBuild);
            try {
                wspace.setDescription(wsDescription);
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.outputProvider.append("Restoring setting \"Project -> Build Automatically\" failed:");
                this.outputProvider.append("  " + e.getMessage());
            }
        }
    }

    private void initialize() throws CoreException {
        this.deactivateAutoBuilding();
        this.outputProvider.append("Creating temporary project...");
        this.createTemporaryProject();
    }

    @Override
    public void compileJavaFiles(AbstractGenerator outputProvider, Set<JavaFileInformation> javaFiles) throws Exception {
        this.outputProvider = outputProvider;
        this.initialize();
        for (JavaFileInformation fileInfo : javaFiles) {
            String fileName;
            IPackageFragment filePackage = this.rootPackage.getPackageFragment(fileInfo.getPackageName());
            if (!filePackage.exists()) {
                filePackage = this.rootPackage.createPackageFragment(fileInfo.getPackageName(), true, null);
                this.createdPackages.add(filePackage);
            }
            if (!(fileName = fileInfo.getName()).endsWith(".java")) {
                fileName = String.valueOf(fileName) + ".java";
            }
            ICompilationUnit cu = filePackage.createCompilationUnit(fileName, fileInfo.getContent(), true, null);
            File exportedFile = ((IFile)cu.getCorrespondingResource()).getLocation().toFile();
            fileInfo.setFile(exportedFile);
        }
        this.configureDebugOptions();
        this.outputProvider.append("Starting project build...");
        this.tmpProject.build(6, (IProgressMonitor)new BuildProgressMonitor());
        this.outputProvider.append("Build finished.");
        for (JavaFileInformation fileInfo : javaFiles) {
            IResource classFile;
            Path path = new Path(fileInfo.getPackageName().replace('.', File.separatorChar));
            IFolder folder = this.binFolder.getFolder((IPath)path);
            String fileName = fileInfo.getName();
            if (fileName.endsWith(".java")) {
                int index = fileName.lastIndexOf(".java");
                fileName = fileName.substring(0, index);
            }
            if ((classFile = folder.findMember(fileName = String.valueOf(fileName) + ".class")) instanceof IFile) {
                fileInfo.setClassFile(((IFile)classFile).getLocation().toFile());
                continue;
            }
            System.err.println("error, didn't generate file: " + fileName);
        }
    }

    private void configureDebugOptions() {
        if (this.debugInfo) {
            this.tmpJavaProject.setOption("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
            this.tmpJavaProject.setOption("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            this.tmpJavaProject.setOption("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
    }

    private String getCodeComplianceLevel() {
        String compliance = null;
        switch (this.codeComplianceLevel) {
            case 0: {
                compliance = "1.3";
                break;
            }
            case 1: {
                compliance = "1.4";
                break;
            }
            case 2: {
                compliance = "1.5";
                break;
            }
            case 3: {
                compliance = "1.6";
                break;
            }
            default: {
                compliance = "1.5";
            }
        }
        return compliance;
    }

    @Override
    public void exportNonJavaFiles(Set<FileInformation> nonJavaFiles) throws Exception {
        for (FileInformation fileInfo : nonJavaFiles) {
            IFolder sourceFolder = (IFolder)this.rootPackage.getCorrespondingResource();
            IFile iFile = sourceFolder.getFile(fileInfo.getName());
            iFile.create((InputStream)new ByteArrayInputStream(fileInfo.getContent().getBytes()), true, null);
            fileInfo.setFile(iFile.getLocation().toFile());
        }
    }

    @Override
    public void cleanUp() {
        if (this.removeProject) {
            this.outputProvider.append("Removing temporary project...");
            try {
                this.deleteTemporaryProject();
            }
            catch (CoreException e) {
                this.outputProvider.append(e.toString());
                this.outputProvider.append(e.getLocalizedMessage());
            }
        }
        this.restoreAutoBuilding();
    }

    void appendOutput(String text) {
        this.outputProvider.append(text);
    }

    class BuildProgressMonitor
    extends NullProgressMonitor {
        BuildProgressMonitor() {
        }

        public void subTask(String name) {
            EclipseJavaCompiler.this.appendOutput(name);
        }
    }
}

