/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.reclipse.generator.generation.AbstractGenerator;
import org.reclipse.generator.ui.GeneratorUIActivator;
import org.reclipse.generator.ui.wizard.SelectCatalogWizardPage;
import org.reclipse.generator.ui.wizard.SelectFileWizardPage;
import org.reclipse.structure.specification.PSCatalog;

public abstract class ExportWizard
extends Wizard
implements IExportWizard {
    private static final String EXPORT_WIZARD_SECTION = "ExportWizard";
    protected SelectCatalogWizardPage modelPage;
    protected SelectFileWizardPage filePage;
    private IStructuredSelection selection;
    private PSCatalog catalog;

    public ExportWizard() {
        IDialogSettings workbenchSettings = GeneratorUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(EXPORT_WIZARD_SECTION);
        if (section == null) {
            section = workbenchSettings.addNewSection(EXPORT_WIZARD_SECTION);
        }
        this.setDialogSettings(section);
        this.filePage = new SelectFileWizardPage("Select file for output.");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.modelPage = new SelectCatalogWizardPage("Select a psc file", this.selection);
        this.modelPage.setDescription("Choose the pattern specification catalog file.");
        this.addPage((IWizardPage)this.modelPage);
        this.addPage((IWizardPage)this.filePage);
    }

    public PSCatalog getSelectedModel() {
        if (this.catalog != null) {
            return this.catalog;
        }
        IFile selectedProject = this.modelPage.getFirstSelection();
        URI resourceURI = URI.createFileURI((String)selectedProject.getFullPath().toOSString());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = null;
        try {
            resource = resourceSet.getResource(resourceURI, true);
        }
        catch (Exception e) {
            resource = resourceSet.getResource(resourceURI, false);
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        EObject obj = (EObject)resource.getContents().get(0);
        if (obj instanceof PSCatalog) {
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            this.catalog = (PSCatalog)obj;
            return this.catalog;
        }
        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Problems occured during loading of resource " + resourceURI.path()));
        return null;
    }

    public boolean performFinish() {
        this.filePage.finish();
        AbstractGenerator generator = this.provideGenerator();
        generator.addToElementsToProcess((Object)this.getSelectedModel());
        File catalogFile = new File(this.filePage.getExportFileName());
        generator.setOutputTo(catalogFile);
        generator.schedule();
        return true;
    }

    private void refreshWorkspace(File catalogFile) {
        IContainer iFile;
        Path path = null;
        try {
            path = new Path(catalogFile.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (path != null && (iFile = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path)) != null && iFile.getParent() != null) {
            try {
                iFile.getParent().refreshLocal(1, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract Collection<String> getRequiredPlugins();

    protected abstract AbstractGenerator provideGenerator();
}

