/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.generator.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExportOptionsPage
extends WizardPage {
    private static final String REMOVE_PROJECT = "removeProject";
    private static final String REMOVE_ELEMENTS = "removeElements";
    private static final String DEBUG_INFORMATION = "debugInformation";
    private static final String CODE_COMPLIANCE_LEVEL = "codeComplianceLevel";
    private Combo complianceCombo;
    private Button removeProjectCheckButton;
    private Button removeElementsCheckButton;
    private Button debugInformationCheckButton;

    public ExportOptionsPage() {
        super("ExportOptionsPage");
        this.setTitle("Export Catalog");
        this.setDescription("Set additional options.");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.createGenerationOptionsComponent(composite);
        Label label = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.createDebugOptionsComponent(composite);
        this.initialize();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createGenerationOptionsComponent(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Catalog generation options:");
        Composite complianceComposite = new Composite(composite, 0);
        complianceComposite.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        complianceComposite.setLayout((Layout)gridLayout);
        Label complianceLabel = new Label(complianceComposite, 0);
        complianceLabel.setText("Code Compliance Level: ");
        this.complianceCombo = new Combo(complianceComposite, 8);
        this.complianceCombo.add("1.3", 0);
        this.complianceCombo.add("1.4", 1);
        this.complianceCombo.add("1.5", 2);
        this.complianceCombo.add("1.6", 3);
    }

    private void createDebugOptionsComponent(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Debugging options:");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.removeProjectCheckButton = new Button(parent, 32);
        this.removeProjectCheckButton.setText("Remove temporary project after generation");
        this.removeProjectCheckButton.setToolTipText("Remove the temporal Eclipse project after generating and compiling the catalog.");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.removeProjectCheckButton.setLayoutData((Object)gridData);
        this.removeElementsCheckButton = new Button(parent, 32);
        this.removeElementsCheckButton.setText("Remove temporary elements from model after generation");
        this.removeElementsCheckButton.setToolTipText("Remove the temporary elements from model after generation");
        this.debugInformationCheckButton = new Button(parent, 32);
        this.debugInformationCheckButton.setText("Generate with debug information");
        this.debugInformationCheckButton.setToolTipText("Compile code with debug information.");
    }

    private void initialize() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            try {
                int complianceLevel = settings.getInt(CODE_COMPLIANCE_LEVEL);
                this.complianceCombo.select(complianceLevel);
            }
            catch (NumberFormatException nfe) {
                this.complianceCombo.select(2);
            }
            boolean removeProject = settings.getBoolean(REMOVE_PROJECT);
            this.removeProjectCheckButton.setSelection(removeProject);
            boolean removeElements = settings.getBoolean(REMOVE_ELEMENTS);
            this.removeElementsCheckButton.setSelection(removeElements);
            boolean debugInformation = settings.getBoolean(DEBUG_INFORMATION);
            this.debugInformationCheckButton.setSelection(debugInformation);
        }
    }

    public boolean isRemoveProject() {
        return this.removeProjectCheckButton.getSelection();
    }

    public int getSelectedComplianceLevel() {
        return this.complianceCombo.getSelectionIndex();
    }

    public boolean isRemoveTemporaryElements() {
        return this.removeElementsCheckButton.getSelection();
    }

    public boolean isDebugInformation() {
        return this.debugInformationCheckButton.getSelection();
    }

    public void finish() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(CODE_COMPLIANCE_LEVEL, this.getSelectedComplianceLevel());
            settings.put(REMOVE_PROJECT, this.isRemoveProject());
            settings.put(REMOVE_ELEMENTS, this.isRemoveTemporaryElements());
            settings.put(DEBUG_INFORMATION, this.isDebugInformation());
        }
    }
}

