/*
 * uniqueRandom.java   Version 1.0 02/17/97 rrh
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)uniqueRandom.java	1.2 10/23/97
 */
package spec.benchmarks._208_cst;


import java.util.*;

//
// uniqueRandom - Generate a sequence of unique psuedo-random integers
//
//

public class uniqueRandom
   {
   public int size;
   private int end;
   private int base;
   private int [] a;
   private Random random = new Random(0);



   uniqueRandom(long seed, int start, int stop)
      {
      base = start;
      size = stop - start;

      a = new int[size];

      reset(seed);
      }

   uniqueRandom(long seed, int size)
      {
      base = 0;
      this.size = size;

      a = new int[size];

      reset(seed);
      }



   void reset()
      {
      int i;

      for (i = 0; i < size; i++)
         a[i] = i + base;

      end = size;
      }



   void reset(long seed)
      {
      reset();

      random.setSeed(seed);
      }



   int next()
      {
      int r, v;


      if ( end == 0 ) reset();

      r = (int)(((random.nextLong() & 0x7FFFFFFF) * end) >> 31);

      v = a[r];

      a[r] = a[--end];

      return v;
      }

   }

