/*
 * VectorTest.java   Version 1.0 11/07/97 rrh, Kaivalya, Salina
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)VectorTest.java	1.2 10/23/97
 */
package spec.benchmarks._208_cst;


import java.util.*;

public class VectorTest
   {
   int size;
   Vector vector;
   uniqueRandom ur;
   String [] str;
   Output o = new Output();

   VectorTest(int size)
      {
      this.size = size;

      vector = new Vector();

      ur = new uniqueRandom(0, size);
      }



   int runTest(int iterations, boolean verbose)
      {
      int i, j, r;
      long sum;
      long start, stop, t1 = 0, t2 = 0;


      start = System.currentTimeMillis();

      o.println("Running VectorTest["+size+"]: " +
             iterations+" iterations");

      while ( iterations-- > 0 )
         {
         ur.reset(0);

//       o.print("   Initializing ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i++)
            {
            r = ur.next();
            vector.addElement(new Integer(r));
            }

         Integer [] Ia = new Integer[size];
         vector.copyInto(Ia);

         if ( ((size > 0) && vector.isEmpty()) )
            {
            o.println("ERROR:unexpected isEmpty");
            return 1;
            }

         if ( vector.size() != size )
            {
            o.println("ERROR:size error");
            return 1;
            }

//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

//       o.print("   elementAt test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         ur.reset(0);
         for (i = 0; i < size; i++)
            {
            r = ur.next();

            if ( ((Integer)vector.elementAt(i)).intValue() != r )
               {
               o.println("ERROR:elementAt miscompare element:"+i);
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


//       o.print("   Enumeration test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         ur.reset(0);
         for (Enumeration e = vector.elements(); e.hasMoreElements();)
            {
            r = ur.next();

            if ( ((Integer)e.nextElement()).intValue() != r )
               {
               o.println("ERROR:enumeration miscompare");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();



//       o.print("   copyInto test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         ur.reset(0);
         for (i = 0; i < size; i++)
            {
            r = ur.next();

            if ( (Ia[i].intValue() != r) || (Ia[i] != vector.elementAt(i)) ||
                    (((Integer)vector.elementAt(i)).intValue() != r) )
               {
               o.println("ERROR:copyInto miscompare");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


         Integer I;
//       o.print("   indexOf test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i += (size/17))
            {
            I = (Integer)vector.elementAt(i);
            j = vector.indexOf(I);

            if ( i != j )
               {
               o.println("ERROR:indexOf miscompare");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


//       o.print("   removeElement test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i += (size/32))
            if ( vector.removeElement(Ia[i]) == false )
               {
               o.println("ERROR: remove element not found");
               return 1;
               }

         for (i = 0; i < size; i += (size/32))
            if ( vector.contains(Ia[i]) )
               {
               o.println("ERROR: element not removed");
               return 1;
               }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

//       o.print("   insertElementAt test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i += (size/32))
            vector.insertElementAt(Ia[i], i);

         for (i = 0; i < size; i += (size/32))
            if ( (!vector.contains(Ia[i])) || (vector.elementAt(i) != Ia[i]) )
               {
               o.println("ERROR: element insertion problem");
               return 1;
               }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


//       o.print("   elementAt sum test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0, sum = 0; i < size; i++)
            sum += (long)((Integer)vector.elementAt(i)).intValue();

         if ( (size > 0) && vector.isEmpty() )
            {
            o.println("\n\n   ERROR in VectorTest:unexpected isEmpty");
            return 1;
            }

         vector.removeAllElements();
         if ( !vector.isEmpty() )
            {
            o.println("\n\n   ERROR in VectorTest:expected isEmpty");
            return 1;
            }

//       o.print("OK:"+sum);
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

         Ia = null;
         }

      ur = null;
      vector = null;

      stop = System.currentTimeMillis();

      if ( verbose )
         o.println("Done in "+(stop-start)/1000.0+"secs");
      
      o.println("Verified");
 
      return 0;
      }


   }

