/*
 * StackTest.java   Version 1.0 11/07/97 rrh, kaivalya
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)StackTest.java	1.2 10/23/97
 */
package spec.benchmarks._208_cst;


import java.util.*;

public class StackTest
   {
   int size;
   Stack stack;
   uniqueRandom ur;
   Integer Ia[];
   Output o = new Output();

   StackTest(int size)
      {
      this.size = size;
      }

   int runTest(int iterations, boolean verbose)
      {
      int i, j, r;
      long sum;
      long start, stop;
      long t1 = 0, t2 = 0;
      int iter = iterations;


      start = System.currentTimeMillis();

      o.println("Running StackTest["+size+"]: " +
             iterations+" iterations");

      Ia = new Integer[size];
      ur = new uniqueRandom(0, size);
      stack = new Stack();

      while ( iter-- > 0 )
         {
         ur.reset(0);

//       o.print("   Initializing ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i++)
            {
            r = ur.next();
            Ia[i] = new Integer(r);
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

         if ( !stack.empty() )
            {
            o.println("ERROR:expected empty");
            return 1;
            }

//       o.print("   push/peek test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i++)
            {
            stack.push(Ia[i]);

            if ( stack.peek() != Ia[i] )
               {
               o.println("ERROR:peek miscompare");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

         if ( stack.empty() )
            {
            o.println("ERROR:unexpected empty");
            return 1;
            }


//       o.print("   search test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i += (size>>5))
            {
            if ( stack.search(Ia[i]) < 0 )
               {
               o.println("ERROR:search failure");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();



//       o.print("   pop/peek test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = size-1; i >= 0; i--)
            {
            if ( stack.peek() != Ia[i] )
               {
               o.println("ERROR:peek miscompare");
               return 1;
               }

            if ( stack.pop() != Ia[i] )
               {
               o.println("ERROR:pop miscompare");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


         if ( !stack.empty() )
            {
            o.println("ERROR:expected empty");
            return 1;
            }

         }

      Ia = null;
      ur = null;
      stack = null;

      stop = System.currentTimeMillis();

      if ( verbose )
         {
         o.print("Done in "+(stop-start)/1000.0+" seconds");
         if ( iterations > 1 )
            o.print(" ("+((stop-start)/iterations/1000.0)+" seconds/iteration)");
         o.println();
         }

      o.println("Verified");

      return 0;
      }



   }

