/*
 * HashTableTest.java   Version 1.0 11/07/97 rrh, kmd salina
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)HashTableTest.java	1.2 10/23/97
 */
package spec.benchmarks._208_cst;

import java.util.*;
import java.lang.*;

public class HashTableTest
   {
   int size;
   Hashtable ht;
   String Sa[];

   HashTableTest(int size)
      {
      this.size = size;
      }

   int runTest(int iterations, boolean verbose)
      {
      int i, j;
      long start, stop;
      long t1 = 0, t2 = 0;
      int iter = iterations;
      long l = 0;
      char ca[] = new char[18];
      Output o = new Output();


      start = System.currentTimeMillis();
      o.println("Running HashTableTest["+size+"]: " +
             iterations+" iterations");

      o.flush();

//      o.print("   Initializing ... ");
//      o.flush();
      
      if ( verbose )
         t1 = System.currentTimeMillis();
      ht = new Hashtable();
      Sa = new String[size];
      for (i = 0; i < size; i++)
         {

         for (j = 0; j < ca.length; j++)
            {
            ca[j] = (char)(((l >> 24) & 0x3F) + ' ');

            l = (l << 16) + l + 97327;
            }

         Sa[i] = new String(ca);
         //o.println(Sa[i]);
         }
//    o.print("OK");
      if ( verbose )
         {
         t2 = System.currentTimeMillis();
         o.print(" ("+(t2-t1)/1000.0+" seconds)");
         }
//    o.println();


      while ( iter-- > 0 )
         {
         if ( !ht.isEmpty() )
            {
            o.println("ERROR:expected empty");
            return 1;
            }

//       o.print("   put test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i++)
            ht.put(Sa[i], Sa[i]);

//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

         if ( ht.isEmpty() )
            {
            o.println("ERROR:unexpected empty");
            return 1;
            }

//       o.print("   get test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i++)
            {
            if ( ht.get(Sa[i]) == null )
               {
               o.println("ERROR:get failure");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

//       o.print("   remove partial test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();

         for (i = 0; i < size; i += 2)
            ht.remove(Sa[i]);
//	 o.print("OK");
	 if ( verbose )
	    {
            t2 = System.currentTimeMillis();
   	    o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//	 o.println();

//         o.print("   lookup removed elements ... ");o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();

         for (i = 0; i < size; i += 2)
            {
            if ( ht.get(Sa[i]) != null )
               {
               o.println("ERROR:element not removed");
               return 1;
               }
            }
//         o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//         o.println();

//         o.print("   remove test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 1; i < size; i+=2)
            ht.remove(Sa[i]);

         if ( !ht.isEmpty() )
            {
            o.println("ERROR:expected empty");
            return 1;
            }

//         o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//         o.println();
         }

      ht = null;
      Sa = null;

      stop = System.currentTimeMillis();

      if ( verbose )
         {
         o.print("Done in "+(stop-start)/1000.0+" seconds");
         if ( iterations > 1 )
            o.print(" ("+((stop-start)/iterations/1000.0)+" seconds/iteration)");
         o.println();
         }

      o.print("Verified\n");

      return 0;
      }

   }

