/*
 * BitSetTest.java   Version 1.0 11/07/97 rrh, kmd
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 * SPEC development version @(#)BitSetTest.java	1.2 10/23/97
 */
package spec.benchmarks._208_cst;



import java.util.*;

public class BitSetTest
   {
   int size;
   BitSet bs, bs1;

   BitSetTest(int size)
      {
      this.size = size * 64;
      }

   int runTest(int iterations, boolean verbose)
      {
      int i;
      long start, stop;
      long t1 = 0, t2 = 0;
      int iter = iterations;
      long l = 0;
      Output o = new Output();



      start = System.currentTimeMillis();

      o.println("Running BitSetTest["+size+"]: " +
             iterations+" iterations");
      o.flush();

      if ( verbose )
         t1 = System.currentTimeMillis();
/*
      o.print("   Initializing ... "); 
      o.flush();
*/      
      bs = new BitSet();

//    o.print("OK");

      if ( verbose )
         {
         t2 = System.currentTimeMillis();
         o.print(" ("+(t2-t1)/1000.0+" seconds)");
         }
//    o.println();

      while ( iter-- > 0 )
         {
//       o.print("   set/clear test ... "); o.flush();

         if ( verbose )
            t1 = System.currentTimeMillis();

         for (i = 0; i < size; i++)
            {
            if ( (i & 1) == 1 )
               bs.set(i);
            else
               bs.clear(i);

          //  if ( (bs.size() >> 6) != ((i+1) >> 6) )
          //     {
          //     o.println("ERROR:incorrect size");
          //     return 1;
          //     }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

//       o.print("   get test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         for (i = 0; i < size; i++)
            {
            if ( (((i & 1) == 1) && (bs.get(i) != true)) ||
                 (((i & 1) == 0) && (bs.get(i) != false)) )
               {
               o.println("ERROR:get failure");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


//       o.print("   clone test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         bs1 = (BitSet)bs.clone();
         for (i = 0; i < size; i++)
            {
            if ( bs1.get(i) != bs.get(i) )
               {
               o.println("ERROR:clone failure (misscompare)");
               return 1;
               }

            bs1.set(i);
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();


//       o.print("   xor test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         bs.xor(bs1);
         for (i = 0; i < size; i++)
            {
            if ( (((i & 1) == 1) && (bs.get(i) != false)) ||
                 (((i & 1) == 0) && (bs.get(i) != true)) )
               {
               o.println("ERROR:xor failure");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

//       o.print("   and test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         bs.and(bs1);
         for (i = 0; i < size; i++)
            {
            if ( (((i & 1) == 1) && (bs.get(i) != false)) ||
                 (((i & 1) == 0) && (bs.get(i) != true)) )
               {
               o.println("ERROR:and failure");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();

//       o.print("   or test ... "); o.flush();
         if ( verbose )
            t1 = System.currentTimeMillis();
         bs.or(bs1);
         for (i = 0; i < size; i++)
            {
            if ( !bs.get(i)  )
               {
               o.println("ERROR:or failure");
               return 1;
               }
            }
//       o.print("OK");
         if ( verbose )
            {
            t2 = System.currentTimeMillis();
            o.print(" ("+(t2-t1)/1000.0+" seconds)");
            }
//       o.println();
         }

      bs = null;
      bs1 = null;

      stop = System.currentTimeMillis();

      if ( verbose )
         {
         o.print("Done in "+(stop-start)/1000.0+" seconds");
         if ( iterations > 1 )
            o.print(" ("+((stop-start)/iterations/1000.0)+" seconds/iteration)");

         o.println();
         }

      o.print("Verified\n");

      return 0;
      }



   }

