package org.pluginbuilder.anttasks;

import java.io.File;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BuildFailedCheckTask implements Condition {

  private String file;

  public boolean eval() {
    File report = new File( file );
    if (!report.exists()) {
      throw new BuildException( "Cannot find file: " + file );
    }
    try {
      Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse( report );
      Element firstElement = doc.getDocumentElement();

      NodeList elementsByTagName = firstElement.getElementsByTagName( "testsuite" );
      for (int i = 0; i < elementsByTagName.getLength(); i++) {
        Element e = (Element) elementsByTagName.item( i );
        if (Integer.parseInt( e.getAttribute( "errors" ) ) > 0 || Integer.parseInt( e.getAttribute( "failures" ) ) > 0) {
          return true;
        }
      }
      return false;
    } catch (Exception e) {
      return true;
    }

  }

  public void setReportFile(String file) {
    this.file = file;

  }
}
