/*
 * Vector.java
 *
 * Copyright (c) 1996 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Implements the functionality of a 3-space vector.
 *
 */
package spec.benchmarks._205_raytrace;
//import Point;

/**
 * class Vector
 */
public class Vector extends Point {

    /**
     * Vector
     */
    public
    Vector() { 

	Set(0.0f, 0.0f, 0.0f);	

    }

    /**
     * Vector
     * @param newX
     * @param newY
     * @param newZ
     */
    public
    Vector(float newX, float newY, float newZ) { 
	super(newX,newY,newZ);
	

    }

    /**
     * Vector
     * @param newvec
     */
    public
    Vector(Vector newvec) { 

	 Set(newvec.GetX(), newvec.GetY(), newvec.GetZ());
    }

    /**
     * Cross
     * @param op1
     * @param op2
     * @return Vector
     */
    public 
    Vector Cross(Vector op1, Vector op2) { 

	 Set((op1.GetY() * op2.GetZ()) - (op1.GetZ() * op2.GetY()),
		(op1.GetZ() * op2.GetX()) - (op1.GetX() * op2.GetZ()),
		(op1.GetX() * op2.GetY()) - (op1.GetY() * op2.GetX()));
	 return (this);
    }

    /**
     * Scale
     * @param newlen
     * @return Vector
     */
    public 
    Vector Scale(float newlen) { 

	 float len = Length();
	 if (len != 0.0f) {
		float factor = newlen / len;
		Set(GetX() * factor, GetY() * factor, GetZ() * factor);
	 }
	 return (this);
    }

    /**
     * Negate
     * @return Vector
     */
    public 
    Vector Negate() { 

	 Set(-GetX(), -GetY(), -GetZ());
	 return (this);
    }

    /**
     * Normalize
     * @return Vector
     */
    public
    Vector Normalize() { 

	 return (Scale(1.0f));
    }

    /**
     * Sub
     * @param op1
     * @param op2
     * @return Vector
     */
    public 
    Vector Sub(Point op1, Point op2) { 

	 Set(op1.GetX() - op2.GetX(), op1.GetY() - op2.GetY(),
		op1.GetZ() - op2.GetZ());
	 return (this);
    }

    /**
     * Dot
     * @param operand
     * @return float
     */
    public 
    float Dot(Vector operand) { 

	 return (GetX() * operand.GetX() + GetY() * operand.GetY() + GetZ() *
		    operand.GetZ());
    }

    /**
     * SquaredLength
     * @return float
     */
    public
    float SquaredLength() { 

	 return (GetX() * GetX() + GetY() * GetY() + GetZ() * GetZ());
    }

    /**
     * Length
     * @return float
     */
    public
    float Length() { 

	 return ((float) Math.sqrt(SquaredLength()));
    }

};
