/*
 * SphereObj.java
 *
 * Copyright (c) 1996 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * The class for a sphere, holding its origin and radius. Implements the
 * intersection test of a ray with the sphere.
 *
 */
package spec.benchmarks._205_raytrace;
//import IntersectPt;
//import Material;
//import ObjectType;
//import Point;
//import Ray;
//import Vector;

/**
 * class SphereObj
 */
public class SphereObj extends ObjectType {
    private Point Origin;
    private float Radius;
    private float RadiusSquare;

    /**
     * SphereObj
     * @param objmaterial
     * @param newobjID
     * @param neworigin
     * @param newradius
     * @param MaxX
     * @param MinX
     * @param MaxY
     * @param MinY
     * @param MaxZ
     * @param MinZ
     */
    public 
    SphereObj(Material objmaterial, int newobjID, Point neworigin,
		float newradius, Point max, Point min) {
	 super(objmaterial,newobjID);
	 Origin=neworigin;
	 Radius=newradius;
	

	 RadiusSquare = Radius * Radius;
	 GetMax().SetX(Origin.GetX() + Radius);
	 GetMax().SetY(Origin.GetY() + Radius);
	 GetMax().SetZ(Origin.GetZ() + Radius);
	 GetMin().SetX(Origin.GetX() - Radius);
	 GetMin().SetY(Origin.GetY() - Radius);
	 GetMin().SetZ(Origin.GetZ() - Radius);
	 if (GetMax().GetX() > max.GetX()) max.SetX(GetMax().GetX());
	 if (GetMax().GetY() > max.GetY()) max.SetY(GetMax().GetY());
	 if (GetMax().GetZ() > max.GetZ()) max.SetZ(GetMax().GetZ());
	 if (GetMin().GetX() < min.GetX()) min.SetX(GetMin().GetX());
	 if (GetMin().GetY() < min.GetY()) min.SetY(GetMin().GetY());
	 if (GetMin().GetZ() < min.GetZ()) min.SetZ(GetMin().GetZ());
    }

    /**
     * Intersect
     * @param ray
     * @param pt
     * @return boolean
     */
    public 
    boolean Intersect(Ray ray, IntersectPt pt) { 

	 Vector OC = new Vector();
	 float l2OC, tCA, t2HC;

	 OC.Sub(Origin, ray.GetOrigin());
	 l2OC = OC.SquaredLength();
	 tCA = OC.Dot(ray.GetDirection());
	 if (l2OC >= RadiusSquare && tCA <= 0) return (false);
	 t2HC = RadiusSquare - l2OC + tCA * tCA;
	 if (t2HC < 0) return (false);
	 if (l2OC <= RadiusSquare) {
		pt.SetT(tCA + (float) Math.sqrt(t2HC));
		if (pt.GetT() < pt.GetThreshold()) return (false);
		pt.SetEnter(false);
		pt.GetIntersection().Combine(ray.GetOrigin(),
						ray.GetDirection(), 1.0f,
						pt.GetT());
	 } else {
		pt.SetT(tCA - (float) Math.sqrt(t2HC));
		pt.SetEnter(true);
		if (pt.GetT() < pt.GetThreshold()) {
		    pt.SetT(tCA + (float) Math.sqrt(t2HC));
		    pt.SetEnter(false);
		}
		pt.GetIntersection().Combine(ray.GetOrigin(),
						ray.GetDirection(), 1.0f,
						pt.GetT());
	 }
	 pt.SetIntersectObj(this);
	 GetCachePt().Set(ray.GetID(), pt);
	 return (true);
    }

    /**
     * FindNormal
     * @param point
     * @param normal
     */
    public 
    void FindNormal(Point point, Vector normal) { 

	 normal.Sub(point, Origin);
	 normal.Normalize();
    }

};
