/*
 * IntersectPt.java
 *
 * Copyright (c) 1996 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * This holds a ray intersection point with an object, as well as the t
 * parameter of the ray when intersecting the object, whether it is entering
 * or leaving the object, the intersected object and the original object from
 * which the ray came. Does the intersection test on a list of objects.
 *
 */
package spec.benchmarks._205_raytrace;
//import CacheIntersectPt;
//import ObjectType;
//import ObjNode;
//import OctNode;
//import Point;
//import Ray;

/**
 * class IntersectPt
 */
public class IntersectPt  {
    private float t;
    private boolean Enter;
    private ObjectType IntersectObj;
    private int OriginalObjID;
    private Point Intersection;
    private final static float Threshold = 1.0e-4f;

    /**
     * SetIsectPt
     * @param isectpt
     */
    protected
    void SetIsectPt(IntersectPt isectpt) { 

	 t = isectpt.GetT();
	 Enter = isectpt.GetEnter();
	 IntersectObj = isectpt.GetIntersectObj();
	 OriginalObjID = isectpt.GetOriginal();
	 Intersection.Set(isectpt.GetIntersection().GetX(),
				isectpt.GetIntersection().GetY(),
				isectpt.GetIntersection().GetZ());
    }

    /**
     * IntersectPt
     */
    public
    IntersectPt() { 
	t=0.0f;
	Intersection = new Point();

    }

    /**
     * FindNearestIsect
     * @param octree
     * @param ray
     * @param originID
     * @param level
     * @param isectnode
     * @return boolean
     */
    public 
    boolean FindNearestIsect(OctNode octree, Ray ray, int originID, int level,
	OctNode isectnode) { 

	 Point testpt = new Point(ray.GetOrigin());
	 OctNode current;
	 ObjNode currentnode;
	 CacheIntersectPt isectptr;
	 IntersectPt test = new IntersectPt();

	 if (level == 0) testpt.Combine(ray.GetOrigin(), ray.GetDirection(),
					1.0f, Threshold);
	 current = octree.FindTreeNode(testpt);
	 IntersectObj = null;
	 while (current != null) {
		currentnode = current.GetList();
		while (currentnode != null) {
		    boolean found = false;
		    if (currentnode.GetObj().GetCachePt().GetID() ==
			ray.GetID()) {
			isectptr = currentnode.GetObj().GetCachePt();
			if (current ==
			    current.FindTreeNode(isectptr.GetIntersection())) {
			    if (IntersectObj == null) {
				SetIsectPt(isectptr);
				isectnode.Copy(current);
			    } else {
				if (isectptr.GetT() < t) {
				    SetIsectPt(isectptr);
				    isectnode.Copy(current);
				}
			    }
			    found = true;
			}
		    }
		    if (!found) {
			test.SetOrigID(originID);
			if (currentnode.GetObj().Intersect(ray, test)) {
			    if (current ==
				current.FindTreeNode(test.GetIntersection())) {
				if (IntersectObj == null) {
				    SetIsectPt(test);
				    isectnode.Copy(current);
				} else {
				    if (test.GetT() < t) {
					SetIsectPt(test);
					isectnode.Copy(current);
				    }
				}
			    }
			}
		    }
		    currentnode = currentnode.Next();
		}
		if (IntersectObj == null) {
		    OctNode adjacent = current.Intersect(ray, testpt,
					Threshold);
		    if (adjacent == null) current = null;
		    else current = adjacent.FindTreeNode(testpt);
		} else current = null;
	 }
	 if (IntersectObj == null) return (false);
	 else return (true);
    }

    /**
     * GetT
     * @return float
     */
    public
    float GetT() { 

	 return (t);
    }

    /**
     * GetEnter
     * @return boolean
     */
    public
    boolean GetEnter() { 

	 return (Enter);
    }

    /**
     * GetIntersectObj
     * @return ObjectType
     */
    public
    ObjectType GetIntersectObj() { 

	 return (IntersectObj);
    }

    /**
     * GetOriginal
     * @return int
     */
    public
    int GetOriginal() { 

	 return (OriginalObjID);
    }

    /**
     * GetIntersection
     * @return Point
     */
    public
    Point GetIntersection() { 

	 return (Intersection);
    }

    /**
     * GetThreshold
     * @return float
     */
    public
    float GetThreshold() { 

	 return (Threshold);
    }

    /**
     * SetT
     * @param newT
     */
    public
    void SetT(float newT) { 

	 t = newT;
    }

    /**
     * SetEnter
     * @param enter
     */
    public
    void SetEnter(boolean enter) { 

	 Enter = enter;
    }

    /**
     * SetIntersectObj
     * @param newObj
     */
    public
    void SetIntersectObj(ObjectType newObj) { 

	 IntersectObj = newObj;
    }

    /**
     * SetOrigID
     * @param ID
     */
    public
    void SetOrigID(int ID) { 

	 OriginalObjID = ID;
    }

};
