/*
 * Si.java   Version 1.0 10/15/97 rrh
 *
 * Copyright (c) 1996 IBM Corporation, Inc. All rights reserved.
 *
 * Permission is expressly granted by IBM Corporation only for short-term and
 * limited distribution within the SPEC voting member companies for use in
 * preparation of a benchmark suite.
 *
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 *
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *
 * Randy Heisch       IBM Corp. - Austin, TX
 *
 */
package spec.benchmarks._210_si;
import spec.harness.*;

import java.util.*;
import java.io.*;


//--------------------------------------------------------------------------
// Si - Simple interpreter
// written by Randy Heisch
// 02/08/97
//
// This version does not use StreamTokenizer (which in 1.1b, uses           
// buffered reads which invalidates is.available which is used here to
// calculate stream position).
//
// Language syntax:
//
//  prog  -> stmts EOF
//
//  stmts -> stmt stmts           |
//           e
//
//  bstmt -> stmt                 |
//           { stmts }
//
//  stmt  -> if expr bstmt              |
//           if expr bstmt else bstmt   |
//           while expr bstmt           |
//           print prtstrs;             |
//           printf fmtstr, expr;       |
//           VAR = expr;
//
//  prtstrs -> prtstr prtstrs     |
//             %expr 
//             e
//
//  fmtstr -> "[str]%[w][.p]f|E|$|t[str]"
//
//           w - field width
//           p - number decimal places
//           f - FP format
//           e - exponential format
//           E - Engineering exp notation (powers of 3 exponent)
//           $ - monetary format ($1,000.00, ect)
//           t - decimal comma format (1,000,000)
//
//
//  prtstr ->  expr               |
//             string
//
//  expr      -> e1 E1
//  E1        -> '<' | '>' | '=' | '<=' | '>=' e1 E1 | e
//
//  e1        -> e2 E2
//  E2        -> '|' | '+' | '-' e2 E2 | e
//
//  e2        -> factor E3
//  E3        -> '&' | '*' | '/' factor E3 | e
//
//  factor    -> (expr)         |
//               id             |
//               number         |
//               -expr          |
//
//---------------------------------------------------------------------------
//


class Symbol
   {
   int token;
   double value;

   Symbol(int t, double v)
      {
      token = t;
      value = v;
      }
   }


class Lexer
   {
   public static final int EOF    =  -1;
   public static final int NUM    =  -2;
   public static final int IF     =  -3;
   public static final int ELSE   =  -4;
   public static final int PRINT  =  -5;
   public static final int WHILE  =  -6;
   public static final int ID     =  -7;
   public static final int LSHFT  =  -8;
   public static final int RSHFT  =  -9;
   public static final int LE     = -10;
   public static final int GE     = -11;
   public static final int EQ     = -12;
   public static final int NE     = -13;
   public static final int STRING = -14;
   public static final int PRINTF = -15;

   boolean debug = false;



   InputStream is;

   Token tok;
   Hashtable ht;

   private double value;
   private Symbol symbol;
   public String str;
   public int available;




   Lexer(InputStream is)
      {
      this.is = is;
      tok = new Token(is);

      ht = new Hashtable();

      // Put in keywords
      ht.put("if", new Symbol(IF, ID));
      ht.put("else", new Symbol(ELSE, ID));
      ht.put("print", new Symbol(PRINT, ID));
      ht.put("printf", new Symbol(PRINTF, ID));
      ht.put("while", new Symbol(WHILE, ID));
      }



   double get_value() { return value; }
   Symbol get_symbol() { return symbol; }

   private void ise()
      {
      spec.harness.Context.out.println("ERROR reading from input stream");
      System.exit(1);
	return;	
      }

   int next()
      {
      int rc = -99;


      try { available = is.available(); }
      catch ( IOException e ) { ise(); };

      if (debug)
	 spec.harness.Context.out.println("available() = "+available);

      try { tok.nextToken(); } catch ( IOException e ) { ise(); };

      switch(tok.ttype)
         {
         case Token.TT_EOF:
            if ( debug )
               spec.harness.Context.out.println("token=TT_EOF");
            rc = EOF;
         break;

         case Token.TT_NUMBER:
            if ( debug )
               spec.harness.Context.out.print("token=TT_NUMBER: "+tok.nval+" ");
            value = tok.nval;
            rc = NUM;
         break;

         case Token.TT_WORD:
            if ( debug )
               spec.harness.Context.out.print("token=TT_WORD:   "+tok.sval+" ");

            if ( (symbol = (Symbol)ht.get(tok.sval)) == null )
               {
               symbol = new Symbol(ID, 0);

               ht.put(tok.sval, symbol);

               if ( debug )
                  spec.harness.Context.out.print("new symbol ("+tok.sval+")");

               rc = ID;
               }
            else
               rc = symbol.token;

         break;

         case '"':
            str = tok.sval;
            rc = STRING;
         break;

         default:
            //spec.harness.Context.out.println(tok.toString());

            rc = tok.ttype;
            switch((char)tok.ttype)
               {
               case '=':
                  try { tok.nextToken(); } catch ( IOException e ) { ise(); } ;

                  if ( (char)tok.ttype == '=' )
                     rc = EQ;
                  else
                     try { tok.pushBack(); } catch (IOException e) { ise(); } ;
               break;

               case '!':
                  try { tok.nextToken(); } catch ( IOException e ) { ise(); } ;

                  if ( (char)tok.ttype == '=' )
                     rc = NE;
                  else
                     try { tok.pushBack(); } catch (IOException e) { ise(); } ;
               break;

               case '<':
                  try { tok.nextToken(); } catch ( IOException e ) { ise(); } ;

                  if ( (char)tok.ttype == '=' )
                     rc = LE;
                  else
                  if ( (char)tok.ttype == '<' )
                     rc = LSHFT;
                  else
                     try { tok.pushBack(); } catch (IOException e) { ise(); } ;
               break;

               case '>':
                  try { tok.nextToken(); } catch ( IOException e ) { ise(); } ;

                  if ( (char)tok.ttype == '=' )
                     rc = GE;
                  else
                  if ( (char)tok.ttype == '>' )
                     rc = RSHFT;
                  else
                     try { tok.pushBack(); } catch (IOException e) { ise(); } ;
               break;
               }

         break;
         }


      if ( debug )
         spec.harness.Context.out.println("tokentype:"+rc+" ("+(char)rc+")");

      return rc;
      }

   }



class Jint
   {
  
   InputStream is;
   String filename = "";
   int num_bytes;
   Lexer lexer;
   int token;
   Stack stack = new Stack();
   Symbol symbol;
   int width = 0;

   boolean debug = false;


   private void ioe()
      {
      spec.harness.Context.out.println("ERROR accessing input file: "+filename);
      //System.exit(1);
	return;	
      }

   void set_pos(long p)
      {
      try { is.reset(); } catch ( IOException e ) { ioe(); };
      try { is.skip(p); } catch ( IOException e ) { ioe(); };
      }

   long get_pos()
      {
      long r = 0;

      r = num_bytes - lexer.available;

      return r;
      }

   void error(String s)
      {
      int c = 0, ln = 1, cp = 1;
      long pos, p;

      pos = get_pos();
      set_pos(0L);

      for (p = 0, cp = 1; p < pos; p++, cp++)
	 {
	 try { c = is.read(); } catch (IOException e) 
	    {
	    spec.harness.Context.out.println("ERROR reading input file");
	   // System.exit(1);
	   return; 
	    }
	    
	 if ( c == '\n' || c == '\r')
	    {
	    ln++;
	    cp = 1;
	    }
	 }

      spec.harness.Context.out.print(s);
      spec.harness.Context.out.println(", near character "+cp+", line "+ln);
      System.exit(1);
        return; 
      }


   void read_file()
      {
      int act = 0;
      byte[] buffer = null;

      try {
	spec.io.FileInputStream sif = new spec.io.FileInputStream(filename);
	num_bytes = sif.getContentLength();
	buffer = new byte[num_bytes];
	
	int bytes_read;
	while ( (bytes_read = sif.read(buffer, act , (num_bytes - act))) > 0){
	  act = act +  bytes_read;
	}
	sif.close();
	  
        if ( act != num_bytes ){
	  spec.harness.Context.out.println("ERROR reading test input file");
	  return;
	}
		

      }
      catch (IOException e) { ioe(); };
      is = (InputStream) new ByteArrayInputStream(buffer, 0, num_bytes);
    }


   Jint(String filename)
      {
      this.filename = filename;

      read_file();
      }


   void parse()
      {

      lexer = new Lexer(is);

      while ( token != Lexer.EOF )
         {

         token = lexer.next();

         while ( token != Lexer.EOF)
            stmt();
         }

      }


   void scan2stmt_end()
      {
      int obr;

      if ( token == '{' )
         {
         obr = 1;

         while ( obr > 0 )
            {
            token = lexer.next();

            if ( token == '{' ) obr++;
            if ( token == '}' ) obr--;
            }
         }
      else
         do { token = lexer.next(); } while ( token != ';' );
      }


   void stmt()
      {
      int i, t, stl, tn;
      int c;
      int fail;
      int label, l1, l2;
      int obr;
      long pos;
      boolean e;
      String ps;
      String spc = "                                                       ";


      switch(token)
         {
         case Lexer.PRINTF:

            token = lexer.next();

            if ( token != Lexer.STRING )
	       error("Format string expected for PRINTF");

            ps = new String(lexer.str);

            token = lexer.next();

            if ( token != ',' )
	       error("comma expected after PRINTF format string");

            token = lexer.next();

            if ( !expr() )
	       error("Expression expected after PRINTF format string");

            Printf.out(ps, ((Double)stack.pop()).doubleValue());

            if ( token != ';' )
               {
               error("Semicolon expected after print");
               break;
               }

            token = lexer.next();

         break;


         case Lexer.PRINT:

            token = lexer.next();

            do
               {
               e = true;
               if ( token == Lexer.STRING )
                  {
                  spec.harness.Context.out.print(lexer.str);
                  token = lexer.next();
                  }
               else
	       if ( token == '%' )
		  {
                  token = lexer.next();
		  if ( !expr() )
		     error("Expression expected after %");
                  else
                     width = (int)((Double)stack.pop()).doubleValue();
		  }
               else
               if ( (e = expr()) )
		  {
		  ps = ((Double)stack.pop()).toString();
		  if ( ps.length() < width )

	          ps = spc.substring(0, (width-ps.length())) + ps;

                  spec.harness.Context.out.print(ps); spec.harness.Context.out.flush();
		  }
               else
               if ( token == ';' )
                  e = false;
               else
                  {
                  e = false;
                  error("Expression or print string expected after PRINT\n");
                  }

               } while ( e );


            if ( token != ';' )
               {
               error("Semicolon expected after print");
               break;
               }

            spec.harness.Context.out.println();

            token = lexer.next();

         break;

         case Lexer.IF:

            token = lexer.next();

            if ( !expr() )
               {
               error("Expression expected after IF\n");
               break;
               }

            if ( ((Double)stack.pop()).doubleValue() > 0 )
               {
               if ( token == '{' )
                  {
                  token = lexer.next();

                  while ( token != '}' )
                     stmt();

                  token = lexer.next();
                  }
               else
                  stmt();
                
               if ( token == Lexer.ELSE )
		  {
		  token = lexer.next();

		  scan2stmt_end();

		  token = lexer.next();
		  }
               }
            else /* If condition false */
               {
               scan2stmt_end();

               token = lexer.next();

	       if ( token == Lexer.ELSE )
		  {
                  token = lexer.next();

                  if ( token == '{' )
                     {
                     token = lexer.next();

                     while ( token != '}' )
                        stmt();

                     token = lexer.next();
                     }
                  else
                     stmt();
		  }
               }

         break;

         case Lexer.WHILE:

            pos = get_pos();

            if ( debug )
               spec.harness.Context.out.println("pos: "+pos);

            token = lexer.next();

            if ( !expr() )
               {
               error("Expression expected after WHILE\n");
               break;
               }

            if ( ((Double)stack.pop()).doubleValue() > 0 )
               {
               if ( token == '{' )
                  {
                  token = lexer.next();

                  while ( token != '}' )
                     stmt();

                  token = lexer.next();
                  }
               else
                  stmt();

               set_pos(pos);

               if ( debug )
                  spec.harness.Context.out.println("Setting position to "+pos);
               }
            else /* condition false */
               scan2stmt_end();

            token = lexer.next();

         break;

         case Lexer.ID:

            symbol = lexer.get_symbol();

            token = lexer.next();

            if ( token != '=' )
               {
               error("= expected for variable assignment");
               break;
               }

            token = lexer.next();

            if ( !expr() )
               {
               error("Expression expected for variable assignment\n");
               break;
               }

            if ( token != ';' )
               {
               error("Semicolon expected after statement");
               break;
               }

            symbol.value = ((Double)stack.pop()).doubleValue();
            //spec.harness.Context.out.println(symbol.value);

            token = lexer.next();

         break;

         default:
            error("Unknown keyword or ID");
         break;
         }

      }


   boolean expr()
      {
      boolean rc;

      rc = e1() && E1();

      return rc;
      }



   boolean e1()
      {
      boolean rc;

      rc = e2() && E2();

      return rc;
      }



   boolean e2()
      {
      boolean rc;

      rc = factor() && E3();

      return rc;
      }


   boolean E1()
      {
      boolean rc = true;
      int ts;
      double v1, v2, r;

      ts = token;
      switch(token)
         {
         case '<': case '>':
         case Lexer.EQ: case Lexer.NE: case Lexer.LE: case Lexer.GE:

            token = lexer.next();

            if ( !(rc = e1()) ) { error("Invalid expression"); break; }

            v2 = ((Double)stack.pop()).doubleValue();
            v1 = ((Double)stack.pop()).doubleValue();

            r = 0.0;
            switch(ts)
               {
               case '<':      if ( v1 < v2  ) r = 1.0; break;
               case '>':      if ( v1 > v2  ) r = 1.0; break;
               case Lexer.LE: if ( v1 <= v2 ) r = 1.0; break;
               case Lexer.GE: if ( v1 >= v2 ) r = 1.0; break;
               case Lexer.EQ: if ( v1 == v2 ) r = 1.0; break;
               case Lexer.NE: if ( v1 != v2 ) r = 1.0; break;
               }

            stack.push(new Double(r));

            if ( !(rc = E1()) ) { error("Invalid expression"); break; }

         break;
         }

      return rc;
      }


   boolean E2()
      {
      boolean rc = true;
      int ts;
      double v1, v2;

      ts = token;

      switch(token)
         {
         case '^': case '|': case '+': case '-':

            token = lexer.next();

            if ( !(rc = e2()) ) { error("Invalid expression"); break; }

            v2 = ((Double)stack.pop()).doubleValue();
            v1 = ((Double)stack.pop()).doubleValue();

            switch(ts)
               {
               case '^':
                  stack.push(new Double(   (double) ((int)v1 ^ (int)v2)   ));
               break;

               case '|':
                  stack.push(new Double((double)((int)v1 | (int)v2)));
               break;

               case '+':  stack.push(new Double(v1 + v2)); break;

               case '-': stack.push(new Double(v1 - v2)); break;
               }

            if ( !(rc = E2()) ) { error("Invalid expression"); break; }

         break;
         }

      return rc;
      }


   boolean E3()
      {
      boolean rc = true;
      int ts;
      double v1, v2;

      ts = token;

      switch(token)
         {
         case '&': case '*': case '/':

            token = lexer.next();

            if ( !(rc = factor()) ) { error("Invalid expression"); break; }

            v2 = ((Double)stack.pop()).doubleValue();
            v1 = ((Double)stack.pop()).doubleValue();

            switch(ts)
               {
               case '&':
                  stack.push(new Double((double)((int)v1 & (int)v2)));
               break;

               case '*': stack.push(new Double(v1 * v2)); break;

               case '/':
                  //spec.harness.Context.out.println(v1+"/"+v2);
                  stack.push(new Double(v1/v2));
               break;

               }

            if ( !(rc = E3()) ) { error("Invalid expression"); break; }

         break;
         }

      return rc;
      }


   boolean factor()
      {
      boolean rc = true;
      int ts;
      double d;

      ts = token;

      switch(token)
         {
         case '(':

            token = lexer.next();

            if ( !(rc = expr()) )
               error("Expression expected after left parenthesis");

            if ( token != ')' )
               {
               rc = false;
               error("Missing right parenthesis");
               }
            else
               token = lexer.next();
         break;

         case Lexer.ID:
            stack.push(new Double(lexer.get_symbol().value));
            token = lexer.next();
         break;

         case Lexer.NUM:
            stack.push(new Double(lexer.get_value()));
            token = lexer.next();
         break;

         case '-':

            token = lexer.next();

            if ( !expr() )
               {
               error("Expression expected after unary minus\n");
               break;
               }

            d = ((Double)stack.pop()).doubleValue();

            stack.push(new Double(-d));

            //token = lexer.next();

         break;

         default: rc = false; break;
         }

      return rc;
      }

   }


public class Si {

  public long inst_main(String[] argv) {
    return run(argv);
  }


  public long run(String[] args) {  
      long start, stop;
      boolean rt = false;

      spec.harness.Context.out.println("\nSmall interpreter, Version 1.0  10/15/97 Randy Heisch");

      if ( args.length >= 3 )
         {
         spec.harness.Context.out.println("\nUsage:\n\n  java Si progfile [-t]\n\n");
         spec.harness.Context.out.println("   where progfile is .si source input; -t optionally displays runtime");
		 return 0;
         }

      if ( args.length >= 2 )
         if ( args[1].equals("-t") )
            rt = true;

      start = System.currentTimeMillis();

      spec.harness.Context.out.println("Reading input file: "+args[0]);
      Jint ji = new Jint(args[0]);

      //spec.harness.Context.out.println("Parsing ... ");
      ji.parse();

      stop = System.currentTimeMillis();

      spec.harness.Context.out.print("\nSi Done");

      if ( rt )
         spec.harness.Context.out.print(" ("+(stop-start)/1000 +" seconds)");

      spec.harness.Context.out.println();

	  return (stop-start);

      }

   }

