# loop counts for non-nested loops:
SELECT *, COUNT(`LoggingPositionID`) FROM logentries GROUP BY `LoggingTraceID`, `LoggingPositionID`

# starting position; only valid for nested loops
# each interval id >= [1] AND id < [2] of each returned subsequent numbers are results for below query
SELECT searched.id AS searchedID, searched.Date, searched.LoggerInvocationCount, searched.CodeLine, searched.IdentifyingName
FROM logentries compared, logentries searched
WHERE
  compared.CodeLine < searched.CodeLine AND
  compared.LoggerInvocationCount = (searched.LoggerInvocationCount-1) AND
  compared.LoggingPositionID <> searched.LoggingPositionID AND
  compared.LogType = 'InIteratorStatement' AND searched.LogType = 'InIteratorStatement'
  AND searched.LoggingPositionID = 'c2605441482658d906fe6674896c0459e1752e42'
LIMIT 0,100;

# support of multiple request
SELECT searched.id AS searchedID, searched.Date, searched.LoggerInvocationCount, searched.CodeLine, searched.IdentifyingName
FROM logentries compared, logentries searched
WHERE
  compared.CodeLine < searched.CodeLine AND
  compared.LoggerInvocationCount = (searched.LoggerInvocationCount-1) AND
  compared.LoggingPositionID <> searched.LoggingPositionID AND
  compared.LogType = 'InIteratorStatement' AND searched.LogType = 'InIteratorStatement'
  AND searched.LoggingPositionID = 'c2605441482658d906fe6674896c0459e1752e42'
GROUP BY searched.LoggingTraceID, searched.id
LIMIT 0,100;

# Feed the first two results (1, 15) into: 
SELECT *, COUNT(`LoggingPositionID`)
FROM logentries
WHERE
  id >= 1 AND
  id < 15 AND
  LoggingPositionID = 'c2605441482658d906fe6674896c0459e1752e42'
GROUP BY `LoggingTraceID`, `LoggingPositionID`

# if the starting position query returns no data; the statement should be
SELECT *, COUNT(`LoggingPositionID`)
FROM logentries
WHERE
  LoggingPositionID = '936ed9677085e55f398073c1c25ef76bbc948ea0'
GROUP BY `LoggingTraceID`, `LoggingPositionID`

