package org.pluginbuilder.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class BundleFileLocator extends Task {

  private String bundleId;
  private String filePath;
  private String eclipseInstallationRoot;
  private String property;

  public BundleFileLocator() {
  }

  public void execute() throws BuildException {
    try {
      FileSet fs = new FileSet();
      String filePart = getFilePath() == null ? "" : "/" + getFilePath();
      String includes = getBundleId() + "_*" + filePart;
      fs.setIncludes( includes );
      File baseDir = new File( getEclipseInstallationRoot() + "/plugins" );
      fs.setDir( baseDir );
      DirectoryScanner ds = fs.getDirectoryScanner( getProject() );
      String[] includedFiles = ds.getIncludedFiles();
      List files = new ArrayList();
      for (int j = 0; j < includedFiles.length; ++j) {
        File file = new File( baseDir, includedFiles[j] );
        files.add( file );
      }
      // files seem to be sorted by name at this point
      if (files.size() == 0) {
        getProject().fireBuildFinished(
            new Exception( "Could not find " + includes + " in installation " + getEclipseInstallationRoot() ) );
      }
      File file = (File) files.get( files.size() - 1 );
      getProject().setProperty( getProperty(), file.getAbsolutePath().replaceAll( "\\\\", "/" ) );
    } catch (Exception e) {
      throw new BuildException( e );
    }
  }

  public String getBundleId() {
    return bundleId;
  }

  public void setBundleId(String bundleId) {
    this.bundleId = bundleId;
  }

  public String getFilePath() {
    return filePath;
  }

  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }

  public String getEclipseInstallationRoot() {
    return eclipseInstallationRoot;
  }

  public void setEclipseInstallationRoot(String eclipseInstallationRoot) {
    this.eclipseInstallationRoot = eclipseInstallationRoot;
  }

  public String getProperty() {
    return property;
  }

  public void setProperty(String property) {
    this.property = property;
  }
}
