package org.pluginbuilder.anttasks;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class GetHostName extends Task {

  private String property = "hostname";
  private boolean failOnError = false;
  private boolean getIp = false;

  public void execute() throws BuildException {
    String value = getProject().getProperty( property );
    if (value != null) {
      log( "Property " + property + " already exists.", Project.MSG_DEBUG );
      return;
    }

    value = getIp ? getHostIp() : getHostName();
    log( "Host " + (getIp ? "IP" : "name") + " is " + value + ".", Project.MSG_DEBUG );
    getProject().setProperty( property, value );
  }

  public void setProperty(String property) {
    this.property = property;
  }

  public void setFailOnError(boolean failOnError) {
    this.failOnError = failOnError;
  }

  public void setGetIp(boolean getIp) {
    this.getIp = getIp;
  }

  private String getHostName() {
    try {
      return InetAddress.getLocalHost().getHostName();
    } catch (UnknownHostException e) {
      if (failOnError)
        throw new BuildException( e );
      else
        return "localhost";
    }
  }

  private String getHostIp() {
    try {
      return InetAddress.getLocalHost().getHostAddress();
    } catch (UnknownHostException e) {
      if (failOnError)
        throw new BuildException( e );
      else
        return "127.0.0.1";
    }
  }

}
