package de.uka.ipd.sdq.cplexparser.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import de.uka.ipd.sdq.cplexparser.ICplexParser;
import de.uka.ipd.sdq.cplexparser.ICplexParserContext;
import de.uka.ipd.sdq.cplexparser.exception.CplexParserException;
import de.uka.ipd.sdq.cplexparser.state.IParserState;
import de.uka.ipd.sdq.cplexparser.state.impl.InitialState;


public class CplexParser implements ICplexParser, ICplexParserContext
{
	private IParserState state  = null;
	
	private Hashtable<String,String> productsIds = new Hashtable<String,String>();	
	private List<Store> stores = new ArrayList<Store>();
	private List<String> tableColumns = new ArrayList<String>();
	private boolean foundErrors = false;
	
	public CplexParser(){
		
	}
	
	public void addStore(Store store) {
		stores.add(store);
	}
	
	public void setState(IParserState state) {
		this.state = state;		
	}
	
	public void putProductById(String key,String value){
		productsIds.put(key, value);
	}	
	
	public String getProductNameById(String key){
		return productsIds.get(key);
	}
	
	
	public void addTableColumn(String name){
		tableColumns.add(name);
	}
	
	public String getTableColumnName(int col) {
		return tableColumns.get(col);
	}
	
	public List<Store> parseString(String parseString) throws CplexParserException {
		productsIds.clear();
		stores.clear();
		tableColumns.clear();
		state = new InitialState();
		int position = 0;
		while (position < parseString.length()) {
			position = state.parse(parseString,position,this);
		}
		if (foundErrors) {
			return null;
		} else {
			return stores;
		}
	}

	public void setFoundErrors()
	{
		foundErrors = true;
		
	}
}
