/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */

package org.ow2.dsrg.fm.tbplib.util;

import java.util.*;

/**
 * Representation of a type. Contains special type for mutex variables as a static
 * field.
 * 
 * @author caitt3am
 *
 */
public class Typedef {

	public static String UNLOCKED = "UNLOCKED", LOCKED = "LOCKED";
	public static Typedef MUTEX_TYPE = new Typedef("-MUTEX-", Arrays.asList(UNLOCKED, LOCKED));
	
	private final List<String> enums;
	private final String name;

	public Typedef(String name, List<String> enums) {
		this.enums = enums;
		this.name = name;
	}

	/**
	 * Returns name of this type.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns list of names of constants that constitutes this type
	 */
	public List<String> getEnums() {
		return enums;
	}

	@Override
	public String toString() {
		StringBuilder bld = new StringBuilder("TYPE ").append(name).append(" { ");
		final int s = enums.size() - 1; 
		for(int i = 0; i < s; i++)
			bld.append(enums.get(i)).append(", ");
		if(s>=0)
			bld.append(enums.get(s));
		bld.append(" }");
		return bld.toString();
	}

	@Override
	public int hashCode() {
		return name.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Typedef))
			return false;
		final Typedef other = (Typedef) obj;
		if (!enums.equals(other.enums))
			return false;
		if (!name.equals(other.name))
			return false;
		return true;
	}
}