/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved;

import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.resolved.TBPResolvedImperativeNode;
import org.ow2.dsrg.fm.tbplib.resolved.visitor.TBPResolvedVisitor;

/**
 * Sync block.
 * @author caitt3am
 *
 */
public class TBPResolvedSync extends TBPResolvedImperativeUnaryNode {

	private final CVRef ref;
	
	/**
	 * Creates new sync block
	 * @param ref - this must be reference to mutex variable
	 * @param child - code to be synchronized
	 */
	public TBPResolvedSync(CVRef ref, TBPResolvedImperativeNode child) {
		super(child);
		this.ref = ref;
		
		if(!ref.getVar().isMutex()){
			throw new TBPResolvingException("Sync is allowed only over mutex variable");
		}
		
	}
	
	@Override
	public <E> E visit(TBPResolvedVisitor<E> visitor) {
		return visitor.visitResolvedSync(this);
	}

	public CVRef getRef() {
		return ref;
	}
}
