/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.resolved;

import org.ow2.dsrg.fm.tbplib.util.Typedef;

/**
 * Interface for classes used to encapsulate resolved reference by 
 * string identifier to value defined elsewhere (formal parameter, 
 * variable, constant).
 * 
 * All implementation should be immutable classes.
 * 
 * @author caitt3am
 *
 */
public interface Reference {

	/**
	 * Encapsulated identifier.
	 */
	String getName();
	
	/**
	 * What is identifier referencing.
	 */
	Typedef getType();
}
