/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

import java.util.List;
import java.util.Set;

/**
 * Helper class. Implements Automaton interface for its descendants.
 * 
 * @author caitt3am
 *
 */
class AutomatonImpl implements Automaton {

	List<State> states;
	State start;
	Set<State> final_states;
	
	public AutomatonImpl(
			List<State> states, State start_state,
			Set<State> final_states) {
		this.states = states;
		this.start = start_state;
		this.final_states = final_states;
	}

	@Override
	public List<State> getStates() {
		return states;
	}

	@Override
	public State getStartState() {
		return start;
	}

	@Override
	public Set<State> getFinalStates() {
		return final_states;
	}
	
	/**
	 * Gets Number of states in automaton.
	 * @return Gets Number of states in automaton.
	 */
	public int getStatesCount() {
		return states.size();
	}
	
	/**
	 * Gets Number of edges in automaton.
	 * @return Gets Number of edges in automaton.
	 */
	public int getEdgesCount() {
		int result = 0;
		if (states != null) {
			for(State s : states) {
				result += s.getEdges().size();
			}
		}
		return result;
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("Type:" + AutomatonImpl.class.getSimpleName() + " instance: " + this.getClass().getName() + '$' + Integer.toHexString( this.hashCode()) + '\n');
		sb.append("\tStart state: \n\t\t" + start + "\n");
		sb.append("\tFinal states:\n");
		for(State finalSt : final_states) {
			sb.append("\t\t");
			sb.append(finalSt + "\n");
		}
		
		sb.append("\tAutomatonStates:\n");
		for(State st : states) {
			sb.append("\t\t");
			sb.append(st + "\n");
		}
		
		return sb.toString();
	}

}
