/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.impl;

import java.util.Iterator;

import org.ow2.dsrg.fm.tbplib.Annotation;
import org.ow2.dsrg.fm.tbplib.TBPNode;

/**
 * Partial implementation of TBPNode. Serves as base class.
 * 
 * @author caitt3am
 *
 */
public abstract class TBPNodeImpl implements TBPNode {

	private TBPNode parent;
	private Annotation annotation;

	public TBPNodeImpl() {
		parent = null;
		annotation = null;
	}
	
	@Override
	public void setParent(TBPNode parent) {
		this.parent = parent;
	}
	@Override
	public TBPNode getParent() {
		return parent;
	}

	@Override
	public Iterator<TBPNode> iterator() {
		return new TBPNodeIterator(this);
	}

	@Override
	public void setAnnotation(Annotation annotation) {
		this.annotation = annotation;
	}
	
	@Override
	public Annotation getAnnotation() {
		return annotation;
	}
	
	/**
	 * Make this node parent of given node.
	 * 
	 * @param child - must be root.
	 */
	protected void parentChild(TBPNode child) {
		if(child.getParent() != null){
			throw new IllegalArgumentException("Cannot insert child that is already in another tree!");
		}
		child.setParent(this);
	}

}
