/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib.impl;

import org.ow2.dsrg.fm.tbplib.TBPNode;

/**
 * Base class for nodes with fixed number of children. All methods from
 * {@link TBPNode} interface that changes number of children throws 
 * {@link UnsupportedOperationException}. 
 * 
 * @author caitt3am
 *
 */
public abstract class TBPBoundedNodeImpl extends TBPNodeImpl {
	
	@Override
	public void addChild(TBPNode childNode) {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public void insertChild(int index, TBPNode childNode) {
		throw new UnsupportedOperationException();
	}
	
	@Override
	public TBPNode removeChild(int index) {
		throw new UnsupportedOperationException();
	}

}
