/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib;

import org.ow2.dsrg.fm.tbplib.parsed.MethodCall;

/**
 * Exception thrown when resolving emit that has unknown definition.
 * 
 * @author caitt3am
 *
 */
public class TBPUndefinedEmitException extends TBPResolvingException {

	private static final long serialVersionUID = 1L;
	private final MethodCall mc;
	
	public TBPUndefinedEmitException(MethodCall mc) {
		this.mc = mc;
	}

	public TBPUndefinedEmitException(String message, MethodCall mc) {
		super(message);
		this.mc = mc;
	}

	public MethodCall getMethodCall() {
		return mc;
	}
}
