/*
 *
 * Threaded Behavior Protocols  - Parsers, Transformations
 * Copyright (C) 2008   DSRG, Charles University in Prague
 *                      http://dsrg.mff.cuni.cz/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 *
 */
package org.ow2.dsrg.fm.tbplib;

import java.util.List;

/**
 * @author caitt3am
 */
public class Annotation {
	
	private final String name;
	private final List<String> names;
	private final List<String> values;

	/**
	 * Construct annotation. Parameters keys and values must have same number
	 * of element and can't be <code>null</code>.
	 * @param name - Name of annotation 
	 * @param keys - collection of string keys
	 * @param values - collection of string values
	 */
	public Annotation(String name, List<String> keys, List<String> values) {
		if(keys.size() != values.size()){
			throw new IllegalArgumentException("Keys and values do not match");
		}
		
		this.name = name;
		this.names = keys;
		this.values = values;
	}

	public String getName() {
		return name;
	}

	public List<String> getKeys() {
		return names;
	}

	public List<String> getValues() {
		return values;
	}
	
	@Override
	public String toString() {
		StringBuilder bld = new StringBuilder("@");
		int s = values.size();
		
		bld.append(name);
		if(s > 0){
			bld.append("(");
				for(int i = 0; i < s; i++){
					bld.append(names.get(i)).append("=").append(values.get(i));
					if(i != s-1){
						bld.append(", ");
					}
				}
			bld.append(")");
		}
		return bld.toString();
	}
}
