package de.uka.ipd.sdq.cplexparser.state.impl;

import de.uka.ipd.sdq.cplexparser.ICplexParserContext;
import de.uka.ipd.sdq.cplexparser.state.IParserState;


public class ExtractTableHeaderColumns implements IParserState
{

	public int parse(String parseString, int position, ICplexParserContext context)
	{
		//omit ":"
		position+=1;
		
		String workingString = parseString.substring(position);
		
		//get the header line
		String[] splitString = workingString.split(":\n",2);
		workingString = splitString[0];
		position += workingString.length()+2;
		workingString = workingString.trim();
		
		splitString = workingString.split(" ");
		for (int i=0;i<splitString.length;i++) {
			if (splitString[i].length()>0) {				
				String productName="";
				//if string starts with a "$" character it is a id
				if (splitString[i].charAt(0) == '$') {
					String idString = splitString[i].substring(1);
					productName = context.getProductNameById(idString);
				}else {
					productName = splitString[i];
				}
				context.addTableColumn(productName);
			}			
		}
		//split the header line
		
		
		context.setState(new SearchForTable());
		
		
		return position;
	}

}
