package de.uka.ipd.sdq.cplexparser.state.impl;

import de.uka.ipd.sdq.cplexparser.ICplexParserContext;
import de.uka.ipd.sdq.cplexparser.exception.CplexParserException;
import de.uka.ipd.sdq.cplexparser.impl.Product;
import de.uka.ipd.sdq.cplexparser.impl.Store;
import de.uka.ipd.sdq.cplexparser.state.IParserState;


public class ExtractTable implements IParserState
{

	public int parse(String parseString, int position, ICplexParserContext context) throws CplexParserException
	{
		
		String[] splitString = parseString.substring(position).split("\n",2);
		String workString = splitString[0];
		position += workString.length()+1;
		
		//table ended
		if (workString.trim().charAt(0)==';') {
			return parseString.length();
		}
		
		splitString = workString.split(" ");
		String storeName = splitString[0].trim();
		int storeId = extractId(storeName);		
		Store store = new Store(storeName,storeId);
		int col = 0;
		for (int i=1;i<splitString.length;i++){
			
			if (splitString[i].length()>0) {
				//System.out.println(">"+context.getTableColumnName(col)+ " "+splitString[i]);
				int amount = Integer.parseInt(splitString[i]);
				Product product = new Product();
				
				try {
					String productName = context.getTableColumnName(col).trim();
					int productId= extractId(productName);				

					product.setName(context.getTableColumnName(col));
					product.setAttributeId(productId);
				}catch(IndexOutOfBoundsException e) {
					throw new CplexParserException("error in table definition: to many columns in table body");
				}
				product.setAmount(amount);
				store.addProduct(product);
				col++;
			}
		}
		context.addStore(store);
		
		return position;
	}
	
	/**
	 * extract the id from the name by removing all non-numerical characters at the beginning
	 * @param name
	 * @return the extracted id
	 */
	private int extractId(String name){
		int id = -1;
		
		//extract the id from the name by removing all non-numerical characters at the beginning 
		//store123 --> 123
		for (int j = 0 ;j<name.length();j++){
			//is char numerical (ascii code 49-47)?
			if (name.charAt(j)>=49 && name.charAt(j)<=57) {
				//get the substring beginning with that character							 
				id =  Integer.parseInt(name.substring(j));
				break;
			}
		}	
		return id;
	}

}
