package de.uka.ipd.sdq.cplexparser.state.impl;

import de.uka.ipd.sdq.cplexparser.ICplexParserContext;
import de.uka.ipd.sdq.cplexparser.exception.CplexParserException;
import de.uka.ipd.sdq.cplexparser.state.IParserState;


public class ExtractProductDefinition implements IParserState
{

	public int parse(String parseString, int position, ICplexParserContext context) throws CplexParserException
	{
		//omit "# $" sequence
		position+=3;			
		String workingString = parseString.substring(position);
		
		//get the id
		//TODO: catch errors
		String[] splitString = workingString.split(" = ",2);		
		if (splitString.length<1) {
			throw new CplexParserException("error in product definition");
		}
		workingString = splitString[0];
		String idString = splitString[0];
		workingString = splitString[1];
		//position += length of " = " and the length of the id
		position+=3+idString.length();
		
		//get the product name
		splitString = workingString.split("\n",2);
		if (splitString.length<1) {
			throw new CplexParserException("error in product definition");
		}		
		String productName = splitString[0];
		workingString = splitString[1];
		
		position+=productName.length() +1;
	
		context.putProductById(idString, productName);
		//System.out.println(">"+parseString.substring(position));
		//position = parseString.length();
		
		context.setState(new SearchForProductDefinition());
		
		return position;
	}
}
