package de.uka.ipd.sdq.cplexparser;

import java.util.List;

import de.uka.ipd.sdq.cplexparser.exception.CplexParserException;
import de.uka.ipd.sdq.cplexparser.impl.Store;

/**
 * A Parser for the output of Cplex. 
 * @author Thomas Fischer
 *
 */
public interface ICplexParser
{
	/**
	 * Parses a cplex output string and returns the stores with there products.
	 * @param parseString The Cplex output
	 * @return A list of stores containing the product amounts or null
	 * @throws CplexParserException 
	 */
	public List<Store> parseString(String parseString) throws CplexParserException;
}
