// SPEC development version @(#)TSP.java	1.2 97/07/10

package spec.benchmarks._207_tsp;
import spec.harness.*;

public class TSP {

  public int	NCITY = 5;
  public int	NGEONEURON;
  public static final double	COUNTRY = 1.00;
  public static final double	NEAR = 0.05;
  public int counter;
  public City city[];
  public geoNeuron gn[];
  public double r[][];
  public double theta, phi, momentum;

  ///////////////////////////////////////////////////////////////////
  //
  //  Init section
  //
  ///////////////////////////////////////////////////////////////////
  public void kohonenInit(){
    theta = 0.5;
    phi   = 0.5;
    momentum = 0.995;
    NCITY = 10;
    NGEONEURON = NCITY*2;
    city = new City[NCITY];
    
    for(int i = 0; i<NCITY; i++) {
      city[i] = new City(Math.random()*COUNTRY, Math.random()*COUNTRY);
    }
    
    double alpha = 0.0;      
    gn = new geoNeuron[NGEONEURON];
    for(int i = 0; i<NGEONEURON; i++){
      gn[i] = new geoNeuron(0.5+0.5*Math.cos(alpha),0.5+0.5*Math.sin(alpha));
      alpha += Math.PI *2.0 / (double)(NGEONEURON);
    }
    
    r = new double[NGEONEURON][NGEONEURON];    
    makeR(theta);        
    counter = 0;
  }

  ///////////////////////////////////////////////////////////////////
  //
  //  Problem section
  //
  ///////////////////////////////////////////////////////////////////
  
  public void makeR(double th){
    for(int i=0; i<NGEONEURON; i++){
      r[i][i]= 1.0;
      for(int j=i+1; j<NGEONEURON; j++){
	r[i][j] = Math.exp( -1.0 * ( gn[i].dist(gn[j])*gn[i].dist(gn[j]) )/(2.0*th*th));
	r[j][i] = r[i][j];
      }
    }
  }
  
  // The body of the animator thread.
  public void run() {
    int idx,j;
    double x1,x2,mindist, hash = 1.0;
    int loopct = 1000 * spec.harness.Context.getSpeed();
    Context.out.println( "Loop count = " + loopct );
    
    for (int tmp=0; tmp < loopct ;tmp++) {    
      counter++;
      
      // CHOSE A RANDOM PATTERN
      idx = (int)(Math.random()*NCITY);
      x1 = city[idx].x+(Math.random()*NEAR)-NEAR/2;
      x2 = city[idx].y+(Math.random()*NEAR)-NEAR/2;
      city[idx].choose++;
      
      // SEARCH FOR MINIMAL
      mindist = 100000.0;
      j = -1;
      for(int i=0; i<NGEONEURON;i++){
	double d = (x1 - gn[i].wx)*(x1 - gn[i].wx) + (x2 - gn[i].wy)*(x2 - gn[i].wy);
	//double d = x1*gn[i].wx + x2*gn[i].wy;
	//System.out.println("d="+d);
	if(d < mindist){
	  mindist = d;
	  j = i;
	}
      }
      
      gn[j].update++;
      
      // UPDATE WEIGHTS
      for(int i=0; i<NGEONEURON;i++){
	gn[i].wx += (phi * r[i][j] * (x1 - gn[i].wx));
	gn[i].wy += (phi * r[i][j] * (x2 - gn[i].wy));
      }
      
      // DECREASE LEARNING PARAMETERS
      phi *= momentum;
      theta *= momentum;
      
      // RE-COMPUTE r MATRIX
      makeR(theta);
      
      
      hash += theta*loopct; //**NS**
    }
    Context.out.println( "Finished - Validation value is " + hash );
    Context.out.println( "Double.doubleToLongBits(hash) = "+Double.doubleToLongBits(hash));
  }
  
  
  public long inst_main(String[] args) { 
    kohonenInit();
    run();   
    return 0;
  }
}
