/*
 * @(#)WhichServer.java	1.3 02/05/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 */
package spec.reporter.vendor;
import java.net.*;

public class WhichServer{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private String host;
private String port;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
public WhichServer (String host, String port){
    this.host = host;
    this.port = port;
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

public static void main(String[] args){
    if (args.length > 0){
        WhichServer w = new WhichServer (args[0],"80");
        System.out.println (w.getServer (true));
    }
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public String getServer(){
    return getServer (false);
}

public String getServer (boolean verbose){
    String name = "REQUIRED";
    try{
        URL url = new URL ("http://" + host + ":" + port + "/index.html");
        URLConnection connection = url.openConnection();
        for (int i=1; ;i++){
            String key = connection.getHeaderFieldKey(i);
            if (key == null)
                break;
	    if (verbose)
		System.out.println (key + " = " + connection.getHeaderField(i));
	    if (key.equals ("Server"))
                name = connection.getHeaderField(i);
        }
     }catch (Exception e){
        System.err.println ("Error " + e);
    }
    return name;
}

}//end class

