/*
 * @(#)SolarisX86.java	1.1 02/20/98
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Permission is expressly granted by Sun Microsystems only for short-term and
 * limited distribution within the SPEC member companies for use in
 * preparation of a benchmark suite.
 * 
 * Please delete all copies of this revision after a steering committee vote on
 * this benchmark is taken.
 * 
 * Another revision of this source code will be provided through official SPEC
 * distribution channels if this program passes the OSSC and is to be presented
 * to the general SPEC membership for a final vote.
 * 
 * This source code is provided as is, without any express or implied warranty.
 *
 * SolarisX86
 * return configuration properties appropriate for Solaris/X86 systems
 * determined by running native commands like prtconf(1M).
 */
package spec.reporter.vendor;

import java.io.*;
import java.util.Properties;

public class SolarisX86 implements VendorConfig{

/*
 * labels found in the prtconf output
 */
private static String[] labels = {
    "Memory size:",
    "name:",
    "System Configuration:"
};
private Properties values = new Properties();

public Properties getProperties (Properties props, String cOrS,
    PrintStream err)
{
    String cs = "spec." + cOrS + ".";
    props.put (cs + "hw.fileSystem","UFS");
    String deviceTypeCpu = "device_type:  'cpu'";
    int ncpu = 0;
    for (int i=0; i<labels.length; i++)
        values.put(labels[i],"n/a");
    Process process;
    InputStream co;
    DataInputStream procOutput;
    Runtime r = java.lang.Runtime.getRuntime();
    try{
        process = r.exec ("/usr/sbin/prtconf -pv");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String s;
        while((s = procOutput.readLine()) != null){
            s = s.trim();
            String lbl = s.substring(0,s.indexOf(':')+1).trim();
            String val = s.substring(s.indexOf(':')+1).trim();
            if (s.equals(deviceTypeCpu)){
                ncpu++;
            }else if (values.get(lbl) != null){
                values.put(lbl,val);
            }
        }
        int code = process.waitFor();
        String vendorName = (String) values.get("System Configuration:");
        props.put(cs + "hw.vendor", vendorName);
	props.put (cs + "hw.vendor.url", "REQUIRED");
        s = (String) values.get("Memory size:");
        props.put(cs + "hw.memory",s.substring(0,s.indexOf(' ')));
    }catch (Exception e){
        err.println("Error running prtconf: " + e);
	return props;
    }
    /*
     * uname
     */
    try{
        process = r.exec ("/bin/uname -rv");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String rv = procOutput.readLine();
	if (rv == null)
	    rv = "VERSION REQUIRED";
        props.put(cs + "sw.OS","Solaris " + rv);
    }catch (Exception e){
        err.println("Error running uname: " + e);
        return props;
    }
    /*
     * hostid
     */
    try{
        process = r.exec ("/bin/hostid");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String hid = procOutput.readLine();
	if (hid != null)
            props.put("hostid",hid);
    }catch (Exception e){
        err.println("Error running hostid: " + e);
    }
    /*
     * /etc/hosts
     */
    try{
        DataInputStream hosts = new DataInputStream(
	    new BufferedInputStream(
	    new FileInputStream ("/etc/hosts")));
	String line;
	while ((line = hosts.readLine()) != null){
	    if (line.indexOf ("loghost") > 0){
		int i = line.indexOf ('\t');
		if (i > 0)
                    props.put ("hostIP",line.substring (0,i));
		break;
	    }
	}
    }catch (Exception e){
        err.println("Error reading /etc/hosts: " + e);
    }
    return props;
}

private int hexval(String name){
    try{
	int h = Integer.parseInt((String) values.get(name),16);
   	return h;
    }catch (NumberFormatException e){
    	return 0;
    }
}

}//end class 
