/*
 * @(#)HPUX.java	1.1 02/05/98
 *
 * HPUX
 * return configuration properties appropriate for HP-UX systems
 * determined by running native commands like uname
 */
package spec.reporter.vendor;

import java.io.*;
import java.util.Properties;

public class HPUX implements VendorConfig{

public Properties getProperties (Properties props, String cOrS,
    PrintStream err)
{
    String cs = "spec." + cOrS + ".";
    Process process;
    InputStream co;
    DataInputStream procOutput;
    Runtime r = java.lang.Runtime.getRuntime();

    props.put (cs + "hw.vendor", "Hewlett-Packard");
    props.put (cs + "hw.vendor.url", "http://www.hp.com/");
    /*
     * Model name
     */
    try{
        process = r.exec ("/bin/uname -m");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String model = procOutput.readLine();
	if (model == null)
	    model = "REQUIRED";
        props.put(cs + "hw.model", model);
    }catch (Exception e){
        err.println("Error running uname: " + e);
        return props;
    }

    /*
     * OS version
     */
    try{
        process = r.exec ("/bin/uname -rv");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String rv = procOutput.readLine();
	if (rv == null)
	    rv = "VERSION REQUIRED";
        props.put(cs + "sw.OS","HP-UX " + rv);
    }catch (Exception e){
        err.println("Error running uname: " + e);
        return props;
    }

    /*
     * machine identifier
     */
    try{
        process = r.exec ("/bin/uname -i");
        procOutput = new DataInputStream(
            new BufferedInputStream(process.getInputStream()));
        String hid = procOutput.readLine();
	if (hid != null)
            props.put("hostid",hid);
    }catch (Exception e){
        err.println("Error running hostid: " + e);
    }

    return props;
}

}//end class
