/*
 * @(#)TableGroup.java	1.4 97/08/26
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */

package spec.reporter;

import java.io.*;
import java.util.Properties;
import java.util.StringTokenizer;
import spec.reporter.SpecPropsBranch13;

public class TableGroup{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////
public final static int MAXGROUPS = 10;
public final static int MAXROWS = 10;
public final static int MAXCOLUMNS = 3;

Table[][][] tables =
    new Table[MAXGROUPS][MAXCOLUMNS][MAXROWS];
int[][] rows = new int[MAXGROUPS][MAXCOLUMNS];
boolean[][] anyEntry = new boolean[MAXGROUPS][MAXCOLUMNS];

private static String tableBegin =
    "<TABLE WIDTH=\"100%\" BORDER=0 CELLSPACING=0 CELLPADDING=2>\n";

private static String firstColumn =
    "<TR><TD WIDTH=\"50%\" VALIGN=\"TOP\">\n";

private static String otherColumn =
    "</TD><TD WIDTH=\"50%\" VALIGN=\"TOP\">\n";
    
private static String tableEnd =
    "</TD></TR></TABLE>";


///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private StringBuffer report;
private Properties result;
SpecPropsBranch13 sp;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

TableGroup(DataInputStream in, SpecPropsBranch13 sp) throws IllegalArgumentException{
    this.sp = sp;
    String line;
    String tableTitle = "Untitled";
    try{
        while ((line = in.readLine()) != null){
	    if (line.startsWith("Title")){
		tableTitle = line.substring(5).trim();
	    }else if (line.startsWith("Table")){
		StringTokenizer token =
		    new StringTokenizer(line.substring(5));
		int group = Integer.parseInt(token.nextToken());
		int column = Integer.parseInt(token.nextToken());
		if (group < 0 || group >= MAXGROUPS ||
		    column < 0 || column >= MAXCOLUMNS){
		    throw new IllegalArgumentException(tableTitle);
		}
		int row = rows[group][column]++;
		if (row < 0 || row >= MAXROWS ){
		    throw new IllegalArgumentException(tableTitle);
		}
		tables[group][column][row] = new Table(
		    tableTitle, in, sp);
		anyEntry[group][column] = true;
	    }
        }
    }catch (IOException e){
	spec.harness.Context.out.println("Error: " + e);
    }
}


///////////////////////////////////////
//class method declarations
///////////////////////////////////////

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public String toString(){
    StringBuffer buf = new StringBuffer(tableBegin);
    Table t;
    for (int ig=0; ig<MAXGROUPS; ig++){
    if (!anyEntry[ig][0]) continue;
	buf.append(firstColumn);
        for (int ir=0; ir<MAXROWS; ir++){
	    t = tables[ig][0][ir];
	    if (t != null)
		buf.append(t.toString());
	}
        for (int ic=1; ic<MAXCOLUMNS; ic++){
	    if (!anyEntry[ig][ic]) continue;
	    buf.append(otherColumn);
            for (int ir=0; ir<MAXROWS; ir++){
		t = tables[ig][ic][ir];
		if (t != null)
		    buf.append(t.toString());
	    }
        }
    }
    buf.append(tableEnd);
    return buf.toString();
}


}

