/*
 * @(#)Result.java	1.5 97/10/31
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */

package spec.reporter;

import java.io.*;
import java.text.*;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import spec.reporter.SpecPropsBranch13;
import spec.reporter.Run;

public class Result{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////
private static DecimalFormat ratioFormat = new DecimalFormat ("###.00");
private static double maxBarWidth = 0;
private static DecimalFormat memFormat   = new DecimalFormat ("##.0");

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private int		best = -1;
public StringBuffer	invalidReason = new StringBuffer();
public String		name;
public double		referenceTime;
public Run[]		run;
public boolean		valid = true;
public double		weight;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////
public Result (String name, SpecPropsBranch13 props){
    this.name = name;
    weight = getDouble(props.get ("spec.report." + name + ".weight.ro"));
    referenceTime = getDouble(props.get ("spec.report." + name + ".ref.ro"));
    if (maxBarWidth <= 0)
        maxBarWidth = getDouble(props.get ("spec.report.maxBarWidth"));
    Vector rv = new Vector(5);
    double bestTime = Double.MAX_VALUE;
    for (int i=0; ;i++){
	String t = props.get ("spec.results." + name + ".run" + i + ".time");
	if (t == null) break;
	Run r = new Run (props, i, getDouble(t), this);
	rv.addElement(r);
	if (r.time < bestTime){
	    best = i;
	    bestTime = r.time;
	}
    }
    run = new Run[rv.size()];
    for (int i=0; i < run.length; i++)
	run[i] = (Run) rv.elementAt(i);
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

public static String bars (String label, double base, double peak,
    double highest)
{
    StringBuffer buf = new StringBuffer();
    buf.append ("<TR><TD ROWSPAN=2><FONT SIZE=-1>" + label +
        "</FONT></TD>\n");
    int width = (int) (maxBarWidth * peak / highest);
    buf.append ("  <TD><IMG SRC=\"images/peakbar.gif\" WIDTH=\"" + width + "\"" +
       " HEIGHT=\"13\" ALIGN=\"MIDDLE\"></TD></TR>\n");
    width = (int) (maxBarWidth * base / highest);
    buf.append ("  <TD><IMG SRC=\"images/basebar.gif\" WIDTH=\"" + width + "\"" +
       " HEIGHT=\"13\" ALIGN=\"MIDDLE\"></TD></TR>\n");
    return buf.toString();
}

public static String[] benchmarkList (SpecPropsBranch13 props){
    Vector v = new Vector();
    for( int j = 1 ;; j++ ) {
        String name = props.get("spec.benchmarkGroup1."+((j < 10) ? "0" : "")
+ j);
        if( name == null )
            break;
	String weight = props.get ("spec.report." + name + ".weight.ro");
	if (weight != null && ! weight.equals ("0"))
            v.addElement( name );
    }
    int nel = v.size();
    if (nel == 0)
	return new String[0];
    String[] names = new String [nel];
    for (int i=0; i < nel; i++)
	names[i] = (String) v.elementAt(i);
    return names;
}

private static double getDouble (String s){
    if (s == null) return 0;
    try{
	Double number = new Double(s);
	return number.doubleValue();;
    }catch (NumberFormatException e){
	return 0;
    }
}

private final static String format2places (double x){
    return ratioFormat.format(x + 0.005);
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

public double bestRatio(){
    if (best < 0)
	return 0;
    else
	return run[best].ratio();
}

public double bestTime(){
    if (best < 0)
	return 0;
    else
	return run[best].time;
}

public double firstRatio(){
    if (run.length <= 0)
	return 0;
    else
	return run[0].ratio();
}

public double firstTime(){
    if (run.length <= 0)
	return 0;
    else
	return run[0].time;
}

public String toDetailRows(){
    StringBuffer buf = new StringBuffer("<TR>\n");
    buf.append ("  <TD VALIGN=TOP ROWSPAN=" + run.length +">" +name+ "</TD>\n");
    buf.append ("  <TD VALIGN=TOP ROWSPAN=" + run.length +">" +
	referenceTime + "</TD>\n");
    buf.append (detailRow(0));
    buf.append ("</TR>\n");
    for (int i=1; i < run.length; i++){
        buf.append ("<TR>\n");
        buf.append (detailRow(i));
        buf.append ("</TR>\n");
    }
    return buf.toString();
}

private String detailRow (int n){
    StringBuffer buf = new StringBuffer();
    buf.append ("  <TD ALIGN=RIGHT>" + n + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	format2places(run[n].time) + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	format2places(run[n].ratio()) + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	memFormat.format(run[n].freeMemoryStart) + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	memFormat.format(run[n].freeMemoryEnd) + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	memFormat.format(run[n].totalMemoryStart) + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	memFormat.format(run[n].totalMemoryEnd) + "</TD>\n");
    return buf.toString();
}

public String toRow (double highest){
    StringBuffer buf = new StringBuffer("<TR>\n");
    buf.append ("  <TD>" + name + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
	format2places(firstRatio()) + "</TD>\n");
    buf.append ("  <TD ALIGN=RIGHT>" + 
 	format2places(bestRatio()) + "</TD>\n");
    buf.append ("</TR>\n");
    return buf.toString();
}

public String toBars (double highest){
    return bars (name, firstRatio(), bestRatio(), highest);
}

/*
public String toString(){
    StringBuffer buf = new StringBuffer(name + ":\n");
    buf.append ("Reference time: " + referenceTime + "\n");
    buf.append ("Weight: " + weight + "\n");
    buf.append (run.length + " runs\n");
    for (int i=0; i < run.length; i++){
	buf.append ("Run " + i + "\n");
	buf.append (run[i].toString());
    }
    return buf.toString();
}
*/

}
