/*
 * @(#)Reporter.java	1.5 97/10/31
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */
 
package spec.reporter;

//import java.io.*;
//import java.util.Enumeration;
//import java.util.Properties;
//import spec.harness.SpecProps;

public class Reporter{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////

/*
 * Command line options
 */
private static String optg, opth, optj, optm, optn, opto, optr, optS,
    opts, optt;

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

///////////////////////////////////////
//class method declarations
///////////////////////////////////////

public static void main(String[] args){
    if (! getOpt(args)) return;
	Report r = new Report (optg, opth, optj, optm, optn, optr, optS,
	    opts, optt);
	r.print (opto);
}

private static boolean getOpt(String[] args){
    if (args.length % 2 != 0){
	usage();
	return false;
    }
    for (int i=0; i < args.length-1; i+= 2){
	if      (args[i].equals("-g"))
	    optg = args[i+1];
	else if (args[i].equals("-h"))
	    opth = args[i+1];
	else if (args[i].equals("-j"))
	    optj = args[i+1];
	else if (args[i].equals("-m"))
	    optm = args[i+1];
	else if (args[i].equals("-n"))
	    optn = args[i+1];
	else if (args[i].equals("-o"))
	    opto = args[i+1];
	else if (args[i].equals("-r"))
	    optr = args[i+1];
	else if (args[i].equals("-S"))
	    optS = args[i+1];
	else if (args[i].equals("-s"))
	    opts = args[i+1];
	else if (args[i].equals("-t"))
	    optt = args[i+1];
	else{
	    usage();
	    return false;
	}
    }
    return true;
}

private static void usage(){
    spec.harness.Context.out.println("Usage: java spec.reporter.Reporter [options]\n" +
	"Options are:\n" +
	"-g GraphTable     File containing HTML for graph and table of results\n" +
	"-h Hardware		Hardware system vendor and model\n" +
	"-j [true/false]   Display graph with Java applet (default true)" +
	"-m Metric			Composite metric\n" +
	"-n Name			Benchmark suite name\n" +
	"-o Output			Output file for generated HTML\n" +
 	"-r Results        File containing a results property file.\n" +
	"                  May be contained in a mail message.\n" +
	"-S Spec           File containing SPEC defined properties\n" +
	"-s Software		Software vendor and version\n" +
	"-t Titles			File containing property titles\n" +
	"Default values are:\n" +
	"-g		SPECjava table generated from properties\n" +
	"-h		Property: spec.client.hw.vendor spec.client.hw.model\n" +
	"-m		Property: spec.results.composite.ro\n" +
	"-n		Property: spec.report.suiteName.ro\n" +
	"-o		Property: spec.report.out\n" +
	"-r		Property: spec.report.rawFile\n" +
	"-S		props/spec\n" +
	"-s		Property: spec.client.sw.vendor spec.client.sw.JVM\n" +
	"-t		props/title\n"
    );
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////


}

