/*
 * @(#)Metrics.java	1.5 97/10/31
 * Copyright (c) 1997 Sun Microsystems, Inc. All rights reserved
 */

package spec.reporter;

import java.io.*;
import java.text.*;
import java.util.Properties;
import java.util.StringTokenizer;
import spec.reporter.SpecPropsBranch13;

public class Metrics{

///////////////////////////////////////
//class variable field declarations
///////////////////////////////////////
private static int maxBarWidth = 0;
private static DecimalFormat ratioFormat;

///////////////////////////////////////
//instance variable field declarations
///////////////////////////////////////
private double			baseMetric;
private Result			check;
private double			highestBase = 0;
private double			highestPeak = 0;
private String[]		name;
private double			peakMetric;
private SpecPropsBranch13	props;
private Result[]		result;
private boolean			useJavaGraph;
public boolean			valid;

///////////////////////////////////////
//constructor declarations
///////////////////////////////////////

public Metrics (SpecPropsBranch13 props){
    this.props = props;
    check = new Result ("_200_check", props);
    this.valid = check.valid;
    name = Result.benchmarkList(props);
    result = new Result [name.length];
    for (int i=0; i<result.length; i++){
	result[i] = new Result (name[i], props);
        this.valid = this.valid && result[i].valid;
    }
    calculate();
    ratioFormat = new DecimalFormat ("###.0#");
    if (maxBarWidth <= 0){
        maxBarWidth = getInt(props.get ("spec.report.maxBarWidth"));
        if (maxBarWidth <= 0)
            maxBarWidth = 300;
    }
}

///////////////////////////////////////
//class method declarations
///////////////////////////////////////
private static int getInt (String s){
    if (s == null) return 0;
    try{
	return Integer.parseInt (s);;
    }catch (NumberFormatException e){
	return 0;
    }
}

///////////////////////////////////////
//instance method declarations
///////////////////////////////////////

private void calculate(){
    double productFirst = 1;
    double productBest = 1;
    double weights = 0;
    for (int i=0; i < result.length; i++){
	double wt = result[i].weight;
	double first = result[i].firstRatio();
	double best = result[i].bestRatio();
	productFirst *= Math.pow (first, wt);
	productBest  *= Math.pow (best, wt);
	if (first > highestBase)
	    highestBase = first;
	if (best > highestPeak)
	    highestPeak = best;
	weights += wt;
    }
    baseMetric = Math.pow (productFirst, 1/weights);
    peakMetric = Math.pow (productBest,  1/weights);
}

public String composite(){
    String name;
    if (valid)
        name = "SPECjavaClient98";
    else
	name = "Invalid Result, Geom. Mean";
    return name + " = " +
        ratioFormat.format(baseMetric + 0.005) + " / " +
        ratioFormat.format(peakMetric + 0.005) + " base/peak\n";
}

public String detail(){
//    String[] name = Result.benchmarkList(props);
    StringBuffer buf = new StringBuffer();
    if (!valid){
	buf.append ("<H4>Invalid Result</H4>\n");
	buf.append ("This result is not valid for the following reason(s):\n");
	buf.append ("<PRE>\n");
	if (! check.valid)
	    buf.append (check.invalidReason.toString());
        for (int i=0; i < result.length; i++){
	    buf.append (result[i].invalidReason.toString());
        }
	buf.append ("</PRE>\n");
    }
    buf.append ("<H4>Details of Runs</H4>\n");
    buf.append ("<TABLE BORDER>\n");
    buf.append ("<TR><TH ROWSPAN=2>Benchmark</TH>\n");
    buf.append ("  <TH ROWSPAN=2>Ref. Time</TH>\n");
    buf.append ("  <TH ROWSPAN=2>Run #</TH>\n");
    buf.append ("  <TH ROWSPAN=2>Time (sec)</TH>\n");
    buf.append ("  <TH ROWSPAN=2>Ratio</TH>\n");
    buf.append ("  <TH COLSPAN=2>Free memory (MB)</TH>\n");
    buf.append ("  <TH COLSPAN=2>Total memory (MB)</TH>\n");
    buf.append ("</TR>\n");
    buf.append ("<TR><TH>Start</TH><TH>End</TH>\n");
    buf.append ("    <TH>Start</TH><TH>End</TH></TR>\n");
    for (int i=0; i < result.length; i++){
	buf.append (result[i].toDetailRows());
    }
    buf.append ("</TABLE>\n");
    return buf.toString();
}

private String gifGraph (){
    StringBuffer buf = new StringBuffer();
    buf.append("<TABLE CELLSPACING=0 CELLPADDING=0>\n");
    for (int i=0; i < result.length; i++)
	buf.append (result[i].toBars(highestPeak));
    buf.append (Result.bars ("Mean", baseMetric, peakMetric, highestPeak));
    buf.append("</TABLE>\n");
    return buf.toString();
}

public String javaDetail (String codeBase){
    StringBuffer buf = new StringBuffer();
    buf.append ("<h3>Memory Utilization Graphs</h3>\n" +
	"Free Memory and Total Memory at the end of each run<P>\n" +
        "<applet code=\"BasePeakGraph.class\"" +
            " codebase=\"" + codeBase + "\"" +
            " width=600" +
            " height=700>\n" +
        "<param name=font value=Helvetica>\n" +
        "<param name=fontsize value=9>\n" +
        "<param name=space  value=3>\n");
    int ip = 0;
    for (int i=0; i < result.length; i++){
        Result r = result[i];
        Run[] run = r.run;
        for (int j=0; j < run.length; j++){
	    buf.append (
	        "<param name=label" + ip + " value=" + r.name + ">\n" +
		"<param name=base" + ip + "  value=" + run[j].freeMemoryEnd + ">\n" +
	        "<param name=peak" + ip + "  value=" + run[j].totalMemoryEnd + ">\n");
	    ip++;
        }
    }
    buf.append ("</applet>\n");
    return buf.toString();
}

private String javaGraph (String codeBase){
    StringBuffer buf = new StringBuffer();
    buf.append ("<p><b>SPEC Ratios</b></p>\n" +
        "<applet code=\"BasePeakGraph.class\"" +
            " codebase=\"" + codeBase + "\"" +
            " width=" + maxBarWidth +
            " height=460>\n" +
        "<param name=font value=Helvetica>\n" +
        "<param name=fontsize value=12>\n" +
        "<param name=space  value=5>\n");
    int i;
    for (i=0; i < result.length; i++){
	buf.append ("<param name=label" + i + " value=" +
	    result[i].name + ">\n");
	buf.append ("<param name=base" + i + "  value=" +
	    result[i].firstRatio() + ">\n");
	buf.append ("<param name=peak" + i + "  value=" +
	    result[i].bestRatio() + ">\n");
    }
    buf.append ("<param name=label" + i + " value=Mean>\n" +
        "<param name=base" + i + " value=" + baseMetric + ">\n" +
        "<param name=peak" + i + " value=" + peakMetric + ">\n");
    buf.append ("<!-- For the Java impaired -->\n");
    buf.append (gifGraph());
    buf.append ("</applet>\n");
    return buf.toString();
}

public String tableAndGraph (boolean useJavaGraph, String codeBase){
    StringBuffer buf = new StringBuffer();
    buf.append(
	"<TABLE BORDER>\n" +
	"<TR><TH ALIGN=LEFT ROWSPAN=2>Benchmark</TH>\n" +
	"    <TH COLSPAN=2>SPEC ratios</TH>\n"
	);
    int span = result.length + 3;
    buf.append ("    <TH ROWSPAN=" + span + ">\n");
    if (useJavaGraph)
        buf.append (javaGraph (codeBase));
    else
        buf.append (gifGraph());
    buf.append ("</TH></TR>\n");
    buf.append (
	"<TR><TH ALIGN=RIGHT>Initial</TH>\n" +
	"    <TH ALIGN=RIGHT>Best</TH></TR>\n"
	);
    for (int i=0; i < result.length; i++)
	buf.append (result[i].toRow(highestPeak));
    buf.append(
	"<TR><TH ALIGN=LEFT>Geometric Mean</TH>\n" +
	"    <TH ALIGN=RIGHT>" + ratioFormat.format(baseMetric + .005) +
	"</TH>\n" +
	"    <TH ALIGN=RIGHT>" + ratioFormat.format(peakMetric + .005) +
	"</TH>\n" +
	"</TR>\n</TABLE>\n"
	);
    return buf.toString();
}


} // End Class
